package exercise1;

public class ParkingLot {
	
	private ParkingSpace[] parkingSpaces;
	
	public ParkingLot(int capacity) {
		if ( capacity < 0 ) {
			System.out.println("Error! Array capacity must be a positive value");
			capacity = 40;
		}
		
		parkingSpaces = new ParkingSpace[capacity];
		
		for (int i = 0; i < parkingSpaces.length; i++) {
			parkingSpaces[i] = new ParkingSpace();
			parkingSpaces[i].setFree(true);
		}
	}
	
	public boolean isThereAFreeSpace() {
		for (int i = 0; i < parkingSpaces.length; i++) {
			if ( parkingSpaces[i].isFree() )
				return true;
		}
		return false;
	}
	
	public void parkVehicle(String registrationNum) {
		if ( !isThereAFreeSpace() ) {
			System.out.println("Sorry, no more parking space at the lot");
			return;
		}
		for (int i = 0; i < parkingSpaces.length; i++) {
			if ( parkingSpaces[i].isFree() ) {
				parkingSpaces[i].setFree(false);
				parkingSpaces[i].setRegNum(registrationNum);
				return;
			}
		}
	}
	
	public boolean checkCars(String reg){
		
		for(int i = 0; i < parkingSpaces.length; i++)
			if(parkingSpaces[i].getRegNum() != null)
				if(parkingSpaces[i].getRegNum().equals(reg))
					return true;
		
		return false;
	}
	
	public int checkCars2(String reg){
		
		for(int i = 0; i < parkingSpaces.length; i++)
			if(parkingSpaces[i].getRegNum() != null)
				if(parkingSpaces[i].getRegNum().equals(reg))
					return i;
		
		return -1;
	}
	
	public void removeCar(String regNum) {
		if(!checkCars(regNum)) System.out.println("There is no vehicle!");
		else {
			for(int i = 0; i < parkingSpaces.length; i++) {
				if(!parkingSpaces[i].isFree())
					if(parkingSpaces[i].getRegNum().equals(regNum)) {
						parkingSpaces[i].setFree(true);
						parkingSpaces[i].setRegNum(null);
						return;
					}
			}
		}
	}
	
	public void removeCar2(String regNum) {
		
		int carIndex = checkCars2(regNum);
		if ( carIndex < 0 ) 
			System.out.println("There is no vehicle!");
		else {
			parkingSpaces[carIndex].setFree(true);
			parkingSpaces[carIndex].setRegNum(null);
		}
	}

}





