package exercise2;

import java.util.ArrayList;

public class MotorcycleRegistry {

	private ArrayList<Motorcycle> motorcycles;
	
	public MotorcycleRegistry() {
		motorcycles = new ArrayList<Motorcycle>();
	}
	
	public boolean isInRegistry(Motorcycle m) {
		return motorcycles.contains(m);
	}
	
	public void addToRegistry(Motorcycle m) {
		if ( m != null && !isInRegistry(m) )
			motorcycles.add(m);
	}
	
	public void deleteFromRegistry(Motorcycle m) {
		if ( motorcycles.remove(m) )
			System.out.println("Motorcycle is successfully removed");
		else
			System.out.println("The motorcycle is not in the registry");
	}
	
	public void print() {
		for (int i = 0; i < motorcycles.size(); i++) {
			System.out.println( motorcycles.get(i) );
		}
	}
}
