package assignment6_2011.exhibits;

import java.util.GregorianCalendar;

public abstract class Exhibit {

	private String name;
	
	private String author;
	
	private double price;
	
	private GregorianCalendar dateReceived;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		if ( name != null && name.length() != 0 )
			this.name = name;
		else System.out.println("Error! Value cannot be assigned");
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		if ( author != null && !author.isEmpty() )
			this.author = author;
		else System.out.println("Error! Cannot assign "
				+ "value to the author attribute");
	}

	public double getPrice() {
		return price;
	}

	public void setPrice(double price) {
		if ( price > 0 )
			this.price = price;
		else System.out.println("Error! Price has to "
				+ "be a positive number");
	}

	public GregorianCalendar getDateReceived() {
		return dateReceived;
	}

	public void setDateReceived(GregorianCalendar dateReceived) {
		GregorianCalendar now = new GregorianCalendar();
		if ( dateReceived != null && dateReceived.before(now))
			this.dateReceived = dateReceived;
		else System.out.println("Error! Cannot assign the value to "
				+ "the date received");
	}
	
	public abstract void print(); 
	
}
