package assignment3_2012.cars;

import java.util.GregorianCalendar;
import java.util.LinkedList;

import assignment3_2012.cars.tires.Tire;
import assignment3_2012.cars.tires.searchengine.TireSearchEngine;

public class CarRepairShop implements TireSearchEngine {

	private LinkedList<Tire> tires = new LinkedList<Tire>();
	
	@Override
	public void displayOffer(int height, int width, int diameter, boolean isWinter) {
		for (int i = 0; i < tires.size(); i++) {
			String dimensions = tires.get(i).getDimensions();
			String[] dims = dimensions.split("/");
			if ( Integer.parseInt(dims[0]) == width &&
					Integer.parseInt(dims[1]) == height &&
					Integer.parseInt(dims[2]) == diameter &&
					tires.get(i).isWinterTire() == isWinter )
				System.out.println( tires.get(i) );
		}
		
	}

	@Override
	public void addTire(Tire tire) {
		if ( tire != null && tire.getDateMade().before( new GregorianCalendar() ) )
			tires.addFirst(tire);
		
	}
	

	public void reverseTheOrder() {
		LinkedList<Tire> reversed = new LinkedList<>();
		
		for (int i = tires.size(); i >= 0; i--) {
			reversed.add( tires.get(i) );
		}
		
		tires = reversed;
	}
	
	public void reverseTheOrder2() {
		
		for (int i = 0; i < tires.size()/2; i++) {
			Tire tFront = tires.get(i);
			Tire tRear = tires.get(tires.size() - 1 - i);
			tires.set(i, tRear);
			tires.set(tires.size() - 1 - i, tFront);
		}
	}
}
