package assignment6_2011.gallery;

import java.util.GregorianCalendar;
import java.util.LinkedList;

import assignment6_2011.exhibits.Exhibit;
import assignment6_2011.exhibits.sculptures.Sculpture;

public class Gallery {
	
	private Exhibit[] exhibits;
	
	public Gallery() {
		exhibits = new Exhibit[100];
	}
	
	private boolean isThereAFreeSpace() {
		for (int i = 0; i < exhibits.length; i++) {
			if ( exhibits[i] == null )
				return true;
		}
		return false;
	}
	
	public void addNewExhibit(Exhibit exhibit) {
		if ( exhibit == null || isThereAFreeSpace() == false ) {
			System.out.println("Error! The exhibit cannot be added");
			return;
		}
		
		for (int i = 0; i < exhibits.length; i++) {
			if ( exhibits[i] == null ) {
				exhibits[i] = exhibit;
				exhibits[i].setDateReceived( new GregorianCalendar());
				return;
			}
		}
	}
	
	public void enableDiscount(double discount){
		int lastYear = 
				new GregorianCalendar().get(GregorianCalendar.YEAR)-1;
		
		for(int i=0; i<exhibits.length; i++){
			if(exhibits[i] == null) continue;
			if(exhibits[i].getDateReceived().get(GregorianCalendar.YEAR) 
					== lastYear){
				exhibits[i].setPrice(exhibits[i].getPrice()*((100-discount)/100));
			}
		}
	
	}
	
	public Sculpture[] twoMostExpensive(){
		
		LinkedList<Sculpture> sculptures = new LinkedList<Sculpture>(); 
		
		for (int i = 0; i < exhibits.length; i++) {
			if ( exhibits[i] == null ) continue;
			if (exhibits[i] instanceof Sculpture) {
				Sculpture s = (Sculpture)exhibits[i];
				if ( s.getMaterial().equalsIgnoreCase("bronze") ) {
					if ( sculptures.isEmpty() )
						sculptures.add(s);
					else {
						boolean added = false;
						for (int j = 0; j < sculptures.size(); j++) {
							if (sculptures.get(j).getPrice() <= s.getPrice() ) {
								sculptures.add(j, s);
								added = true;
							}
						}
						if ( !added ) sculptures.addLast(s);
					}
				}
			}
		}
		
		Sculpture[] topPrized = new Sculpture[2];
		topPrized[0] = sculptures.get(0);
		topPrized[1] = sculptures.get(1);
		return topPrized;
	}
	
	

}






