package cars;

import java.util.ArrayList;
import java.util.GregorianCalendar;

import cars.tires.Tire;
import cars.tires.searchengine.TireSearchEngine;

public class CarRepairShop implements TireSearchEngine {

	private ArrayList<Tire>	tires = new ArrayList<Tire>();
	
	@Override
	public void displayOffer(int width, int height, int diameter, boolean isWinter) {
		for (int i = 0; i < tires.size(); i++) {
			String[] dimensions = 
					tires.get(i).getDimensions().split("/");
			int tWidth = Integer.parseInt(dimensions[0]);
			int tHeight = Integer.parseInt(dimensions[1]);
			int tDiameter = Integer.parseInt(dimensions[2]);
			if ( tWidth == width && tHeight == height &&
					tDiameter == diameter && 
					tires.get(i).isWinterTire() == isWinter)
				System.out.println( tires.get(i) );
		}

	}
	
	public void displayOffer2(int width, int height, int diameter, boolean isWinter) {
		String dimension = width + "/" + height + "/" + diameter;
		for (int i = 0; i < tires.size(); i++) {
			if ( tires.get(i).getDimensions().equals(dimension) &&
					tires.get(i).isWinterTire() == isWinter)
				System.out.println( tires.get(i));
		}
	}

	@Override
	public void addTire(Tire tire) {
		if ( tire != null && 
				tire.getDateMade().before(new GregorianCalendar()))
			tires.add(0, tire);
		else System.out.println("Error! The tire cannot be added");

	}
	
	
	

}
