package gallery;

import java.util.GregorianCalendar;
import java.util.LinkedList;

import exhibits.Exhibit;
import exhibits.sculptures.Sculpture;

public class Gallery {

	private Exhibit[] exhibits;
	
	public Gallery() {
		exhibits = new Exhibit[100];
	}
	
	private int indexFree() {
		for (int i = 0; i < exhibits.length; i++) {
			if ( exhibits[i] == null )
				return i;
		}
		return -1;
	}
	
	public void addNewExhibit(Exhibit exhibit) {
		int indexFree = indexFree();
		if ( exhibit != null && indexFree >= 0 ){
			exhibits[indexFree] = exhibit;
			exhibits[indexFree].setDateReceived(new GregorianCalendar());
		} else
			System.out.println("Error! The new exhibit cannot be added");
			
	}
	
	public void enableDiscount(double discount) {
		int lastYear = 
			new GregorianCalendar().get(GregorianCalendar.YEAR) - 1;
		
		for (int i = 0; i < exhibits.length; i++) {
			if ( exhibits[i] == null ) continue;
			if ( exhibits[i].getDateReceived().
					get(GregorianCalendar.YEAR) == lastYear) {
				double currentPrice = exhibits[i].getPrice();
				exhibits[i].setPrice( currentPrice * (100-discount)/100);
			}
		}
	}
	
	public Sculpture[] topPrizedBronzeSculptures() {
		
		LinkedList<Sculpture> sculptures = 
				new LinkedList<Sculpture>();
		
		for (int i = 0; i < exhibits.length; i++) {
			if ( exhibits[i] == null ) continue;
			if ( exhibits[i] instanceof Sculpture ) {
				Sculpture s = (Sculpture)exhibits[i];
				if ( s.getMaterial().equalsIgnoreCase("bronze") ) {
					if ( sculptures.isEmpty() )
						sculptures.add(s);
					else {
						boolean added = false;
						for (int j = 0; j < sculptures.size(); j++) {
							if ( sculptures.get(j).getPrice() <= s.getPrice() ) {
								sculptures.add(j, s);
								added = true;
							}
						}
						if ( !added ) sculptures.addLast(s);
					}
				}
			}
		}
		
		Sculpture[] topPrized = new Sculpture[2];
		topPrized[0] = sculptures.getFirst();
		topPrized[1] = sculptures.get(1);
		return topPrized;
		
 	}
}







