package labs11.assignment1;

import java.util.InputMismatchException;
import java.util.Scanner;

public class KeyboardInput2 {

	public static void scanWrite() {
		Scanner scanner = new Scanner(System.in);
		System.out.println("Please enter some text to"
				+ " test the method");
		String s = scanner.nextLine();
		System.out.println("You've entered: \"" + s + "\"");
	}
	
	public static void readNumbersSumSquares() {
		
		Scanner scanner = new Scanner(System.in);
		System.out.println("You're expected to enter 5 decimal "
				+ "numbers one by one");
		
		double sum = 0;
		for(int i = 1; i <= 5; i++) {
			System.out.println("Please enter " + i + ". number");
			try {
				double number = scanner.nextDouble();
				sum += Math.pow(number, 2);
			} catch (InputMismatchException e) {
				System.err.println("Incorrect value, will be ignored; "
						+ "only decimal numbers allowed");
				scanner.next();
				i--;
			}
		}
		System.out.println("Sum of numbers: " + sum);
	}
	
	public static void readNumbersFindMax() {
		Scanner scanner = new Scanner(System.in);
		System.out.println("You're expected to enter integer values; "
				+ "enter any other value to terminate");
		
		int max = Integer.MIN_VALUE;
		while(true) {
			try {
				int number = scanner.nextInt();
				if ( number > max ) max = number;
			} catch (InputMismatchException e) {
				if ( max != Integer.MIN_VALUE ) {
					System.out.println("Terminating the input");
					System.out.println("Max int value: " + max);
				} else {
					System.out.println("Error! No correct value provided");
				}
				return;
			}
		}
	}
}


