package labs11.assignment2;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;

public class FileIO {

	public void readFromFile(String fileName) throws FileNotFoundException {
		
		Scanner scanner = 
				new Scanner(new FileInputStream(fileName));
		
		String text = "";
		while( scanner.hasNextLine() ) {
			text += scanner.nextLine() + "\n";
		}
		System.out.println(text);
		
		scanner.close();
	}
	
	public void readFromFile2(String fileName) throws IOException {
		
		BufferedReader in = 
				new BufferedReader(new FileReader(fileName));
		
		String text = "";
		String s = in.readLine();
		while( s != null ) {
			text += s + "\n";
			s = in.readLine();
		}
		System.out.println(text);
		
		in.close();
	}
	
	public void writeToFile(String s1, 
			String s2, String fileName) throws IOException{
		
		PrintWriter out = 
				new PrintWriter(new FileWriter(fileName));
		
		out.println(s1);
		out.println(s2);
		out.close();
	}
	
	public void writeNumbersToFile(String fileName) throws IOException {
		DataOutputStream out = 
				new DataOutputStream(new FileOutputStream(fileName));
		
		int[] numbers = {45, 56, 67, 78, 89};
		for (int i = 0; i < numbers.length; i++) {
			out.writeInt(numbers[i]);
			out.writeChar('\n');
		}
		
		out.close();
		
	}
	
	public void readNumbersPrintSum(String fileName) throws IOException {
		DataInputStream in = 
				new DataInputStream(new FileInputStream(fileName));
		
		int sum = 0;
		while(in.available() > 0) {
			sum += in.readInt();
			in.readChar();
		}
		System.out.println("sum: " + sum);
		
		in.close();
	}
}





