package labs11.assignment2;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;

public class FileIO {

	public void readFromFile(String fileName) throws FileNotFoundException {
		
		Scanner scanner = new Scanner(new File(fileName));
		String text = "";
		while( scanner.hasNextLine() ) {
			text += scanner.nextLine() + "\n";
		}
		System.out.println("CONTENT OF THE FILE " + fileName + 
				":\n" + text);
		scanner.close();
	}
	
	public void readFromFile2(String fileName) throws IOException {
		
		BufferedReader in = 
				new BufferedReader(new FileReader(fileName));
		
		String s = in.readLine();
		String text = "";
		while ( s != null ) {
			text += s + "\n";
			s = in.readLine();
		}
		System.out.println("CONTENT OF THE FILE " + fileName + 
				":\n" + text);
		in.close();
	}
	
	public void writeToFile(String s1, String s2, String fileName) throws IOException{
		PrintWriter out = new PrintWriter(new FileWriter(fileName));
		out.println(s1);
		out.println(s2);
		out.close();
	}
	
	public void writeNumbersToFile(String fileName) throws IOException {
		DataOutputStream out = 
				new DataOutputStream(new FileOutputStream(fileName));
		
		int[] numbers = {45,56,67,78,89};
		for (int i = 0; i < numbers.length; i++) {
			writeNumber(numbers[i], out);
		}
		
		out.close();
		
	}
	
	private void writeNumber(int number, DataOutputStream out) throws IOException {
		out.writeInt(number);
		out.writeChar('\n');
	}
	
	public void sumNumbersFromFile(String fileName) throws IOException {
		DataInputStream in = 
				new DataInputStream(new FileInputStream(fileName));
		
		int sum = 0;
		while ( in.available() > 0 ) {
			sum += in.readInt();
			in.readChar();
		}
		System.out.println("sum: " + sum);
		in.close();
	}
}





