package labs12.assignment1;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;

public class Group {
	
	private LinkedList<Person> members = 
			new LinkedList<Person>();
	
	public void addMember(Person p) {
		if(p != null)
			members.add(p);
	}
	
	public void serializeMembers(String fileName) throws IOException {
		
		ObjectOutputStream out = 
				new ObjectOutputStream(new FileOutputStream(fileName));
		
		for (int i = 0; i < members.size(); i++) {
			out.writeObject(members.get(i));
		}
		
		out.close();
	}
	
	public void deserializeMembers(String fileName) throws IOException {
		ObjectInputStream in = 
				new ObjectInputStream(new FileInputStream(fileName));
		
		members.clear();
		
		while(true) {
			try {
				Person p = (Person)in.readObject();
				members.add(p);
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (EOFException e) {
				System.out.println("Reached the end of the file");
				break;
			}
		}
		
		in.close();
	}
	
	public void print() {
		for (int i = 0; i < members.size(); i++) {
			System.out.println( members.get(i).getName() + 
					" " + members.get(i).getSurname() +
					" " + members.get(i).getBankAccountNumber());
		}	
	}

}
