package labs12.assignment2.gui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import labs12.assignment2.business_logic.CurrencyConverter;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Scanner;
import java.awt.event.ActionEvent;

public class ConverterGUI extends JFrame {

	private JPanel contentPane;
	private JLabel lblAmountInRsd;
	private JLabel lblAmountInEuro;
	private JTextField rsdTextField;
	private JTextField euroTextField;
	private JButton btnRsdToEuro;
	private JButton btnEuroToRsd;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					ConverterGUI frame = new ConverterGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public ConverterGUI() {
		setTitle("Currency Converter");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 356, 215);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		contentPane.add(getLblAmountInRsd());
		contentPane.add(getLblAmountInEuro());
		contentPane.add(getRsdTextField());
		contentPane.add(getEuroTextField());
		contentPane.add(getBtnRsdToEuro());
		contentPane.add(getBtnEuroToRsd());
	}
	private JLabel getLblAmountInRsd() {
		if (lblAmountInRsd == null) {
			lblAmountInRsd = new JLabel("Amount in RSD");
			lblAmountInRsd.setBounds(39, 58, 92, 21);
		}
		return lblAmountInRsd;
	}
	private JLabel getLblAmountInEuro() {
		if (lblAmountInEuro == null) {
			lblAmountInEuro = new JLabel("Amount in Euro");
			lblAmountInEuro.setBounds(191, 58, 92, 21);
		}
		return lblAmountInEuro;
	}
	private JTextField getRsdTextField() {
		if (rsdTextField == null) {
			rsdTextField = new JTextField();
			rsdTextField.setBounds(39, 93, 104, 23);
			rsdTextField.setColumns(10);
		}
		return rsdTextField;
	}
	private JTextField getEuroTextField() {
		if (euroTextField == null) {
			euroTextField = new JTextField();
			euroTextField.setBounds(191, 93, 104, 23);
			euroTextField.setColumns(10);
		}
		return euroTextField;
	}
	private JButton getBtnRsdToEuro() {
		if (btnRsdToEuro == null) {
			btnRsdToEuro = new JButton("RSD to Euro");
			btnRsdToEuro.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					DecimalFormat formatter = new DecimalFormat();
					String amountString = rsdTextField.getText();
					try {
						double amountRSD = Double.parseDouble(amountString);
						double amountEuro = CurrencyConverter.convertRSDtoEuro(amountRSD);
						euroTextField.setText( formatter.format(amountEuro) );
					} catch (NumberFormatException e) {
						euroTextField.setText("ERROR! Try again");
					}  // amountEuro + ""
				}
			});
			btnRsdToEuro.setBounds(39, 144, 104, 23);
		}
		return btnRsdToEuro;
	}
	private JButton getBtnEuroToRsd() {
		if (btnEuroToRsd == null) {
			btnEuroToRsd = new JButton("Euro to RSD");
			btnEuroToRsd.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					Scanner scanner = new Scanner(euroTextField.getText());
					if ( scanner.hasNextDouble() ) {
						double amountEuro = scanner.nextDouble();
						double amountRSD = CurrencyConverter.convertEuroToRSD(amountEuro);
						rsdTextField.setText(new DecimalFormat().format(amountRSD));
					} else 
						rsdTextField.setText("ERROR!");
				}
			});
			btnEuroToRsd.setBounds(191, 144, 104, 23);
		}
		return btnEuroToRsd;
	}
}
