package lab12.assignment2.gui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import lab12.assignment2.business_logic.CurrencyConverter;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.util.Scanner;
import java.awt.event.ActionEvent;

public class ConverterGUI extends JFrame {

	private JPanel contentPane;
	private JLabel lblAmountInRsd;
	private JLabel lblAmountInEuro;
	private JTextField rsdTextField;
	private JTextField euroTextField;
	private JButton btnD2EButton;
	private JButton btnE2DButton;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					ConverterGUI frame = new ConverterGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public ConverterGUI() {
		setTitle("Currency converter");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 380, 195);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		contentPane.add(getLblAmountInRsd());
		contentPane.add(getLblAmountInEuro());
		contentPane.add(getRsdTextField());
		contentPane.add(getEuroTextField());
		contentPane.add(getBtnD2EButton());
		contentPane.add(getBtnE2DButton());
	}
	private JLabel getLblAmountInRsd() {
		if (lblAmountInRsd == null) {
			lblAmountInRsd = new JLabel("Amount in RSD");
			lblAmountInRsd.setBounds(44, 49, 107, 23);
		}
		return lblAmountInRsd;
	}
	private JLabel getLblAmountInEuro() {
		if (lblAmountInEuro == null) {
			lblAmountInEuro = new JLabel("Amount in Euro");
			lblAmountInEuro.setBounds(214, 49, 107, 23);
		}
		return lblAmountInEuro;
	}
	private JTextField getRsdTextField() {
		if (rsdTextField == null) {
			rsdTextField = new JTextField();
			rsdTextField.setBounds(44, 84, 107, 23);
			rsdTextField.setColumns(10);
		}
		return rsdTextField;
	}
	private JTextField getEuroTextField() {
		if (euroTextField == null) {
			euroTextField = new JTextField();
			euroTextField.setBounds(214, 84, 107, 23);
			euroTextField.setColumns(10);
		}
		return euroTextField;
	}
	private JButton getBtnD2EButton() {
		if (btnD2EButton == null) {
			btnD2EButton = new JButton("Convert D2E");
			btnD2EButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					String input = rsdTextField.getText();
					try {
						double amountRSD = Double.parseDouble(input);
						double amountEuro = CurrencyConverter.convertRSDToEuro(amountRSD);
						euroTextField.setText( String.format("%.2f", amountEuro));
					} catch (NumberFormatException e) {
						euroTextField.setText("ERROR! Incorrect input!");
					}
					
				}
			});
			btnD2EButton.setBounds(44, 124, 107, 23);
		}
		return btnD2EButton;
	}
	private JButton getBtnE2DButton() {
		if (btnE2DButton == null) {
			btnE2DButton = new JButton("Convert E2D");
			btnE2DButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					Scanner scanner = new Scanner(euroTextField.getText());
					if ( scanner.hasNextDouble() ) {
						double amountEuro = scanner.nextDouble();
						double amountRSD = CurrencyConverter.convertEuroToRSD(amountEuro);
						rsdTextField.setText( String.format("%.2f", amountRSD));
					} else
						rsdTextField.setText("ERROR!");
				}
			});
			btnE2DButton.setBounds(214, 124, 107, 23);
		}
		return btnE2DButton;
	}
}
