package labs12.assignment2.gui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import labs12.assignment2.business_logic.CurrencyConverter;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Scanner;
import java.awt.event.ActionEvent;

public class ConverterGUI extends JFrame {

	private JPanel contentPane;
	private JTextField rsdTextField;
	private JTextField euroTextField;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					ConverterGUI frame = new ConverterGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public ConverterGUI() {
		setTitle("Currency converter");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 396, 213);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JLabel lblNewLabel = new JLabel("Amount in RSD");
		lblNewLabel.setBounds(52, 59, 99, 23);
		contentPane.add(lblNewLabel);
		
		JLabel lblAmountInEuro = new JLabel("Amount in Euro");
		lblAmountInEuro.setBounds(231, 59, 99, 23);
		contentPane.add(lblAmountInEuro);
		
		rsdTextField = new JTextField();
		rsdTextField.setBounds(52, 94, 99, 23);
		contentPane.add(rsdTextField);
		rsdTextField.setColumns(10);
		
		euroTextField = new JTextField();
		euroTextField.setBounds(231, 94, 99, 23);
		contentPane.add(euroTextField);
		euroTextField.setColumns(10);
		
		JButton btnD2E = new JButton("Convert D2E");
		btnD2E.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DecimalFormat formatter = new DecimalFormat();
				String input = rsdTextField.getText();
				try {
					double amountRSD = Double.parseDouble(input);
					double amountEuro = CurrencyConverter.convertRSDToEuro(amountRSD);
					euroTextField.setText( formatter.format(amountEuro)  ); 
										 // amountEuro + ""
				} catch (NumberFormatException e1) {
					euroTextField.setText("ERROR! Try again");
				}
			}
		});
		btnD2E.setBounds(52, 135, 99, 23);
		contentPane.add(btnD2E);
		
		JButton btnE2D = new JButton("Convert E2D");
		btnE2D.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Scanner scanner = new Scanner( euroTextField.getText() );
				if ( scanner.hasNextDouble() ) {
					double amountRSd = CurrencyConverter.
							convertEuroToRSD( scanner.nextDouble());
					rsdTextField.setText( new DecimalFormat().format(amountRSd));
				} else 
					rsdTextField.setText("ERROR!");
				
			}
		});
		btnE2D.setBounds(231, 135, 99, 23);
		contentPane.add(btnE2D);
	}
}
