package assignment5_2102;

import java.io.Serializable;

public class Region implements Serializable {
	
	private String name;
	
	private int birthRate;
	
	private int deathRate;
	
	private int migrationBalance;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		if ( name == null || name.length() < 2 )
			throw new DemographyException("Error! Incorect value for the name attribute");
		this.name = name;
	}

	public int getBirtRate() {
		return birthRate;
	}

	public void setBirtRate(int birtRate) {
		if ( birtRate <= 0 )
			throw new DemographyException("Error! Birth rate must be a positive number");
		this.birthRate = birtRate;
	}

	public int getDeathRate() {
		return deathRate;
	}

	public void setDeathRate(int deathRate) {
		if ( deathRate <= 0 )
			throw new DemographyException("Error!...");
		this.deathRate = deathRate;
	}

	public int getMigrationBalance() {
		return migrationBalance;
	}

	public void setMigrationBalance(int migrationBalance) {
		this.migrationBalance = migrationBalance;
	}

	@Override
	public String toString() {
		return "Region [name=" + name + ", birtRate=" + birthRate + ", deathRate=" + deathRate + ", migrationBalance="
				+ migrationBalance + 
				" change= " + (birthRate - deathRate + migrationBalance) + "]";
	}
	
	

}
