package assignment5_2102;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.util.ArrayList;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JTextArea;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.awt.event.ActionEvent;

public class RegionsGUI extends JFrame {

	private JPanel contentPane;
	private JTextArea mainTextArea;
	private JPanel westPanel;
	private JPanel southPanel;
	private JLabel lblName;
	private JTextField nameTextField;
	private JLabel lblBirthRate;
	private JTextField bRateTextField;
	private JLabel lblDeathRate;
	private JTextField dRateTextField;
	private JLabel lblMigrationBalance;
	private JTextField mBalanceTextField;
	private JButton addButton;
	private JButton btnSave;
	private JButton btnDelete;
	
	private ArrayList<Region> regions = new ArrayList<>();

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					RegionsGUI frame = new RegionsGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public RegionsGUI() {
		setTitle("Regional demographic data");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 300);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
		contentPane.add(getMainTextArea(), BorderLayout.CENTER);
		contentPane.add(getWestPanel(), BorderLayout.WEST);
		contentPane.add(getSouthPanel(), BorderLayout.SOUTH);
	}

	private JTextArea getMainTextArea() {
		if (mainTextArea == null) {
			mainTextArea = new JTextArea();
		}
		return mainTextArea;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setPreferredSize(new Dimension(110, 10));
			westPanel.add(getLblName());
			westPanel.add(getNameTextField());
			westPanel.add(getLblBirthRate());
			westPanel.add(getBRateTextField());
			westPanel.add(getLblDeathRate());
			westPanel.add(getDRateTextField());
			westPanel.add(getLblMigrationBalance());
			westPanel.add(getMBalanceTextField());
		}
		return westPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.add(getAddButton());
			southPanel.add(getBtnSave());
			southPanel.add(getBtnDelete());
		}
		return southPanel;
	}
	private JLabel getLblName() {
		if (lblName == null) {
			lblName = new JLabel("Name:");
		}
		return lblName;
	}
	private JTextField getNameTextField() {
		if (nameTextField == null) {
			nameTextField = new JTextField();
			nameTextField.setColumns(8);
		}
		return nameTextField;
	}
	private JLabel getLblBirthRate() {
		if (lblBirthRate == null) {
			lblBirthRate = new JLabel("Birth rate:");
		}
		return lblBirthRate;
	}
	private JTextField getBRateTextField() {
		if (bRateTextField == null) {
			bRateTextField = new JTextField();
			bRateTextField.setColumns(8);
		}
		return bRateTextField;
	}
	private JLabel getLblDeathRate() {
		if (lblDeathRate == null) {
			lblDeathRate = new JLabel("Death rate:");
		}
		return lblDeathRate;
	}
	private JTextField getDRateTextField() {
		if (dRateTextField == null) {
			dRateTextField = new JTextField();
			dRateTextField.setColumns(8);
		}
		return dRateTextField;
	}
	private JLabel getLblMigrationBalance() {
		if (lblMigrationBalance == null) {
			lblMigrationBalance = new JLabel("Migration balance:");
		}
		return lblMigrationBalance;
	}
	private JTextField getMBalanceTextField() {
		if (mBalanceTextField == null) {
			mBalanceTextField = new JTextField();
			mBalanceTextField.setColumns(8);
		}
		return mBalanceTextField;
	}
	private JButton getAddButton() {
		if (addButton == null) {
			addButton = new JButton("Add");
			addButton.setPreferredSize(new Dimension(70, 23));
		}
		return addButton;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					try {
						ObjectOutputStream growingOut = new ObjectOutputStream(new FileOutputStream("growing_regions.out"));
						ObjectOutputStream dyingOut = new ObjectOutputStream(new FileOutputStream("dying_regions.out"));
						
						for (int i = 0; i < regions.size(); i++) {
							int change = regions.get(i).getBirtRate() + 
									regions.get(i).getMigrationBalance() - 
									regions.get(i).getDeathRate(); 
							if ( change >= 0 ) {
								growingOut.writeObject(regions.get(i));
							} else {
								dyingOut.writeObject(regions.get(i));
							}	
						}
						
						growingOut.close();
						dyingOut.close();
					} catch (FileNotFoundException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					} catch (IOException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
				}
			});
			btnSave.setPreferredSize(new Dimension(70, 23));
		}
		return btnSave;
	}
	private JButton getBtnDelete() {
		if (btnDelete == null) {
			btnDelete = new JButton("Delete");
			btnDelete.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
				}
			});
			btnDelete.setPreferredSize(new Dimension(70, 23));
		}
		return btnDelete;
	}
}
