package labs13.task1.gui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import labs13.task1.bussiness_logic.TextDemo;

import javax.swing.JTextArea;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class TextEditorGUI extends JFrame {

	private JPanel contentPane;
	private JTextArea mainTextArea;
	private JPanel westPanel;
	private JLabel lblNewLabel;
	private JTextField fileTextField;
	private JButton btnLoad;
	private JButton btnDelete;
	private JButton btnSave;
	private JButton btnExit;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					TextEditorGUI frame = new TextEditorGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public TextEditorGUI() {
		setTitle("Text Editor");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 300);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
		contentPane.add(getMainTextArea(), BorderLayout.CENTER);
		contentPane.add(getWestPanel(), BorderLayout.WEST);
	}

	private JTextArea getMainTextArea() {
		if (mainTextArea == null) {
			mainTextArea = new JTextArea();
		}
		return mainTextArea;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setPreferredSize(new Dimension(100, 10));
			westPanel.add(getLblNewLabel());
			westPanel.add(getFileTextField());
			westPanel.add(getBtnLoad());
			westPanel.add(getBtnDelete());
			westPanel.add(getBtnSave());
			westPanel.add(getBtnExit());
		}
		return westPanel;
	}
	private JLabel getLblNewLabel() {
		if (lblNewLabel == null) {
			lblNewLabel = new JLabel("File name:");
		}
		return lblNewLabel;
	}
	private JTextField getFileTextField() {
		if (fileTextField == null) {
			fileTextField = new JTextField();
			fileTextField.setColumns(8);
		}
		return fileTextField;
	}
	private JButton getBtnLoad() {
		if (btnLoad == null) {
			btnLoad = new JButton("Load");
			btnLoad.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String fileName = fileTextField.getText();
					TextDemo textDemo = new TextDemo();
					String text = textDemo.readTextFromFile(fileName);
					if ( text == null )
						mainTextArea.setText("ERROR while reading from file " + fileName);
					else
						mainTextArea.setText(text);
				}
			});
			btnLoad.setPreferredSize(new Dimension(85, 23));
		}
		return btnLoad;
	}
	private JButton getBtnDelete() {
		if (btnDelete == null) {
			btnDelete = new JButton("Delete");
			btnDelete.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					mainTextArea.setText("");
				}
			});
			btnDelete.setPreferredSize(new Dimension(85, 23));
		}
		return btnDelete;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String fileName = fileTextField.getText();
					String text = mainTextArea.getText();
					TextDemo textDemo = new TextDemo();
					textDemo.writeTextToFile(text, fileName);
				}
			});
			btnSave.setPreferredSize(new Dimension(85, 23));
		}
		return btnSave;
	}
	private JButton getBtnExit() {
		if (btnExit == null) {
			btnExit = new JButton("Exit");
			btnExit.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					System.exit(0);
				}
			});
			btnExit.setPreferredSize(new Dimension(85, 23));
		}
		return btnExit;
	}
}
