package assignment5_2012;

import java.io.Serializable;

public class Region implements Serializable {

	
	private static final long serialVersionUID = 1132185389251638555L;

	private String name;
	
	private int birthRate;
	
	private int deathRate;
	
	private int migrationBalance;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		if ( name == null || name.length() < 2 )
			throw new DemographyException("Error! Invalid name value");
		this.name = name;
	}

	public int getBirthRate() {
		return birthRate;
	}

	public void setBirthRate(int birthRate)  {
		if ( birthRate <= 0 )
			throw new DemographyException("Error! Birth rate must be a positive number");
		this.birthRate = birthRate;
	}

	public int getDeathRate() {
		return deathRate;
	}

	public void setDeathRate(int deathRate) {
		if ( deathRate <= 0)
			throw new DemographyException("Error! Death rate must be positive");
		this.deathRate = deathRate;
	}

	public int getMigrationBalance() {
		return migrationBalance;
	}

	public void setMigrationBalance(int migrationBalance) {
		this.migrationBalance = migrationBalance;
	}
	
	public int getChangeInPopulation() {
		return birthRate - deathRate + migrationBalance;
	}

	@Override
	public String toString() {
		return "Region [name=" + name + ", birthRate=" + birthRate + ", deathRate=" + deathRate + ", migrationBalance="
				+ migrationBalance + ", changeInPopulation=" + getChangeInPopulation() + "]";
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Region) {
			Region r = (Region)obj;
			return r.name.equals(this.name);
		} else
			return false;
			
	}
	
	
	
	
}
