package assignment5_2012;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.util.ArrayList;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JTextArea;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class RegionsGUI extends JFrame {

	private JPanel contentPane;
	private JTextArea mainTextArea;
	private JPanel leftPanel;
	private JPanel bottomPanel;
	private JLabel lblName;
	private JTextField nameTextField;
	private JLabel lblBirthRate;
	private JTextField bRateTextField;
	private JLabel lblDeathRate;
	private JTextField dRateTextField;
	private JLabel lblMigrationBalance;
	private JTextField mBalanceTextField;
	private JButton btnAdd;
	private JButton btnSave;
	private JButton btnDelete;

	private ArrayList<Region> regions = new ArrayList<>();
	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					RegionsGUI frame = new RegionsGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public RegionsGUI() {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 300);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
		contentPane.add(getMainTextArea(), BorderLayout.CENTER);
		contentPane.add(getLeftPanel(), BorderLayout.WEST);
		contentPane.add(getBottomPanel(), BorderLayout.SOUTH);
	}

	private JTextArea getMainTextArea() {
		if (mainTextArea == null) {
			mainTextArea = new JTextArea();
		}
		return mainTextArea;
	}
	private JPanel getLeftPanel() {
		if (leftPanel == null) {
			leftPanel = new JPanel();
			leftPanel.setPreferredSize(new Dimension(110, 10));
			leftPanel.add(getLblName());
			leftPanel.add(getNameTextField());
			leftPanel.add(getLblBirthRate());
			leftPanel.add(getBRateTextField());
			leftPanel.add(getLblDeathRate());
			leftPanel.add(getDRateTextField());
			leftPanel.add(getLblMigrationBalance());
			leftPanel.add(getMBalanceTextField());
		}
		return leftPanel;
	}
	private JPanel getBottomPanel() {
		if (bottomPanel == null) {
			bottomPanel = new JPanel();
			bottomPanel.add(getBtnAdd());
			bottomPanel.add(getBtnSave());
			bottomPanel.add(getBtnDelete());
		}
		return bottomPanel;
	}
	private JLabel getLblName() {
		if (lblName == null) {
			lblName = new JLabel("Name:");
		}
		return lblName;
	}
	private JTextField getNameTextField() {
		if (nameTextField == null) {
			nameTextField = new JTextField();
			nameTextField.setColumns(8);
		}
		return nameTextField;
	}
	private JLabel getLblBirthRate() {
		if (lblBirthRate == null) {
			lblBirthRate = new JLabel("Birth rate:");
		}
		return lblBirthRate;
	}
	private JTextField getBRateTextField() {
		if (bRateTextField == null) {
			bRateTextField = new JTextField();
			bRateTextField.setColumns(8);
		}
		return bRateTextField;
	}
	private JLabel getLblDeathRate() {
		if (lblDeathRate == null) {
			lblDeathRate = new JLabel("Death rate:");
		}
		return lblDeathRate;
	}
	private JTextField getDRateTextField() {
		if (dRateTextField == null) {
			dRateTextField = new JTextField();
			dRateTextField.setColumns(8);
		}
		return dRateTextField;
	}
	private JLabel getLblMigrationBalance() {
		if (lblMigrationBalance == null) {
			lblMigrationBalance = new JLabel("Migration balance:");
		}
		return lblMigrationBalance;
	}
	private JTextField getMBalanceTextField() {
		if (mBalanceTextField == null) {
			mBalanceTextField = new JTextField();
			mBalanceTextField.setColumns(8);
		}
		return mBalanceTextField;
	}
	private JButton getBtnAdd() {
		if (btnAdd == null) {
			btnAdd = new JButton("Add");
			btnAdd.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					
					Region region = new Region();
					region.setName( nameTextField.getText());
					try {
						region.setBirthRate( Integer.parseInt( bRateTextField.getText()));
						region.setDeathRate( Integer.parseInt( dRateTextField.getText()));
						region.setMigrationBalance(Integer.parseInt( mBalanceTextField.getText()));
					} catch (NumberFormatException e1) {
						mainTextArea.setText("Error! Problems while parsing numerical values");
						return;
					}
					
					if ( regions.contains(region) ) {
						mainTextArea.setText("Error! It's already in the list");
						return;
					}
					
					if ( regions.isEmpty() ) {
						regions.add(region);
						return;
					}
					
					boolean added = false;
					for (int i = 0; i < regions.size(); i++) {
						if ( regions.get(i).getBirthRate() <= region.getBirthRate() ) {
							regions.add(i, region);
							added = true;
							break;
						}
					}
					
					if ( !added )
						regions.add(regions.size(), region);
					
				}
			});
			btnAdd.setPreferredSize(new Dimension(65, 23));
		}
		return btnAdd;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.setPreferredSize(new Dimension(65, 23));
		}
		return btnSave;
	}
	private JButton getBtnDelete() {
		if (btnDelete == null) {
			btnDelete = new JButton("Delete");
		}
		return btnDelete;
	}
}
