package exhibits;

import java.util.GregorianCalendar;

public abstract class Exhibit {
	private String title;
	private String author;
	private double price;
	private GregorianCalendar dateArrived;
	
	public Exhibit(String title, String author, double price, GregorianCalendar dateArrived) {
		super();
		this.title = title;
		this.author = author;
		this.price = price;
		this.dateArrived = dateArrived;
	}

	public Exhibit() {
		super();
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		if ((title == null) || (title.equals(""))) {
			System.out.println("Error");
			return;
		}
		this.title = title;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		if ((author == null) || (author.equals(""))) {
			System.out.println("Error");
			return;
		}
		this.author = author;
	}

	public double getPrice() {
		return price;
	}

	public void setPrice(double price) {
		if (price <= 0) {
			System.out.println("Error");
			return;
		}
		this.price = price;
	}

	public GregorianCalendar getDateArrived() {
		return dateArrived;
	}

	public void setDateArrived(GregorianCalendar dateArrived) {
		if ((dateArrived == null) || (dateArrived.after(new GregorianCalendar()))) {
			System.out.println("Error");
			return;
		}
		this.dateArrived = dateArrived;
	}
	
	public abstract void print();
}
