package exhibits.sculptures;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

import exhibits.Exhibit;

public class Sculpture extends Exhibit {
	
	private String material;

	public Sculpture(String title, String author, double price, GregorianCalendar dateArrived, String material) {
		super(title, author, price, dateArrived);
		this.material = material;
	}

	public Sculpture() {
		super();
	}

	@Override
	public void print() {
		SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
		
		System.out.println("Sculpture : " + this.getTitle() + '\n' +
							"Author: " + this.getAuthor() + '\n' + 
							"Price: " + this.getPrice() + '\n' +
							"Material: " + material + '\n' +
							"Date arrived: " + df.format(this.getDateArrived().getTime()));
	}

	public String getMaterial() {
		return material;
	}

	public void setMaterial(String material) {
		this.material = material;
	}

}
