package gallery;

import java.util.GregorianCalendar;

import exhibits.Exhibit;
import exhibits.sculptures.Sculpture;

public class Gallery {
	
	private Exhibit [] exhibits;
	
	public Gallery() {
		exhibits = new Exhibit[100];
	}
	
	public void addNewExhibit(Exhibit e) {
		if (e == null) {
			System.out.println("Error");
			return;
		}
		int firstNonOccupied = -1;
		for (int i = 0; i < exhibits.length; i++) {
			if (exhibits[i] == null) {
				firstNonOccupied = i;
				break;
			}
		}
		if (firstNonOccupied != -1) {
			exhibits[firstNonOccupied] = e;
			exhibits[firstNonOccupied].setDateArrived(new GregorianCalendar());
		} else {
			System.out.println("Error");
		}
	}
	
	public void enableDiscount(double discount) {
		for (int i = 0; i < exhibits.length; i++) {
			if (exhibits[i].getDateArrived().YEAR == (new GregorianCalendar()).YEAR - 1) {
				exhibits[i].setPrice(exhibits[i].getPrice() - discount);
			}
		}
	}
	
	public Sculpture [] getTwoMostExpensive() {
		Sculpture [] twoMostExpensive = new Sculpture[2];
		
		double max1 = 0;
		int firstMostExpensive = 0;
		for (int i = 0; i < exhibits.length; i++) {
			if (exhibits[i] == null) {
				break;
			}
			if ((exhibits[i] instanceof Sculpture) &&
					(((Sculpture) exhibits[i]).getMaterial().equals("bronze")) &&
					(exhibits[i].getPrice() > max1)) {
				max1 = exhibits[i].getPrice();
				firstMostExpensive = i;
			}
		}
		
		double max2 = 0;
		int secondMostExpensive = 0;
		for (int i = 0; i < exhibits.length; i++) {
			if (exhibits[i] == null) {
				break;
			}
			if (i == firstMostExpensive) {
				continue;
			}
			if ((exhibits[i] instanceof Sculpture) &&
					(((Sculpture) exhibits[i]).getMaterial().equals("bronze")) &&
					(exhibits[i].getPrice() > max2)) {
				max2 = exhibits[i].getPrice();
				secondMostExpensive = i;
			}
		}
		
		twoMostExpensive[0] = (Sculpture) exhibits[firstMostExpensive];
		twoMostExpensive[1] = (Sculpture) exhibits[secondMostExpensive];
		
		return twoMostExpensive;
	}
	
	public void printAll() {
		for (int i = 0; i < exhibits.length; i++) {
			if (exhibits[i] == null) {
				return;
			}
			exhibits[i].print();
		}
	}

}
