package exercise1;

public class ParkingLot {
	
	private ParkingSpace[] parkingSpaces;
	
	public ParkingLot(int capacity) {
		if ( capacity <= 0 ) {
			System.out.println("Error! Capacity has to be a positive number");
			capacity = 40;
		}
		parkingSpaces = new ParkingSpace[capacity];
		for (int i = 0; i < parkingSpaces.length; i++) {
			parkingSpaces[i] = new ParkingSpace();
			parkingSpaces[i].setFree(true);
		}
		System.out.println("Initialization completed!");
	}
	
	public boolean isThereAFreeSpace() {
		for (int i = 0; i < parkingSpaces.length; i++) {
			if ( parkingSpaces[i].isFree() )
				return true;
		}
		return false;
	}
	
	public void parkVehicle(String regNumber) {
		if ( !isThereAFreeSpace() ) {
			System.out.println("Sorry, the parking is full");
			return;
		}
		for (int i = 0; i < parkingSpaces.length; i++) {
			if ( parkingSpaces[i].isFree() ) {
				parkingSpaces[i].setFree(false);
				parkingSpaces[i].setRegNum(regNumber);
				return; // break;
			}
		}
	}
	
	public boolean isAVehicleParked(String regNumber){
		for (int i = 0; i < parkingSpaces.length; i++) {
			if(parkingSpaces[i].isFree() == false){
				if(parkingSpaces[i].getRegNum().equals(regNumber)){
					return true;
				}
			}
		}
		System.out.println("The vehicle isn't parked here.");
		return false;
	}
	
	public void removeVehicle(String regNum) {
		if(!isAVehicleParked(regNum)) System.out.println("The given vehicle isn't parked here!");
		else {
			for(int i=0; i<parkingSpaces.length;i++){
				if(!parkingSpaces[i].isFree()){
				if(parkingSpaces[i].getRegNum().equals(regNum)){
					parkingSpaces[i].setFree(true);
					parkingSpaces[i].setRegNum(null);
					return;
				}
			}
		}
		}
	}

}
