package exercise2;

import java.util.LinkedList;

public class MotorcycleRegistry {
	
	private LinkedList<Motorcycle> motorcycles;
	
	public MotorcycleRegistry() {
		motorcycles = new LinkedList<Motorcycle>();
	}
	
	public boolean isInRegistry(Motorcycle m) {
		if ( m != null ) {
			return motorcycles.contains(m);
		}
		return false;
	}
	
	public void addToRegistry(Motorcycle m) {
		if ( m != null && !isInRegistry(m) ) {
			motorcycles.add(m);
		}
	}
	
	public void removeFromRegistry(Motorcycle m) {
		if ( motorcycles.remove(m) == false)
			System.out.println("Motorcycle is not in the registry");
	}
	
	public void print() {
		for (int i = 0; i < motorcycles.size(); i++) {
			System.out.println( motorcycles.get(i) );
		}
	}
	

}
