package exercise2;

import java.util.LinkedList;

public class MotorcycleRegistry {

	private LinkedList<Motorcycle> motorcycles;
	
	public MotorcycleRegistry() {
		motorcycles = new LinkedList<Motorcycle>();
	}
	
	public boolean isInRegistry(Motorcycle m) {
		if ( m != null ) {
			return motorcycles.contains(m);
		}
		System.out.println("Error! The object is null");
		return false;
	}
	
	public void addToRegistry(Motorcycle m) {
		if ( m != null && !isInRegistry(m) ) {
			motorcycles.add(m);
		}
	}
	
	public void deleteFromRegistry(Motorcycle m) {
		motorcycles.remove(m);
	}
	
	public void print() {
		for (int i = 0; i < motorcycles.size(); i++) {
			System.out.println( motorcycles.get(i) );
		}
	}
}
