package exercise1;

public class ParkingLot {
	
	private ParkingSpace[] parkingSpaces;
	
	public ParkingLot(int capacity) {
		if ( capacity <= 0 ) {
			System.out.println("Error! Capacity must be a positive number");
			capacity = 40;
		}
		
		parkingSpaces = new ParkingSpace[capacity];
		
		for (int i = 0; i < parkingSpaces.length; i++) {
			parkingSpaces[i] = new ParkingSpace();
			parkingSpaces[i].setFree(true);
		}
		
//		System.out.println("The initialization completed");
	}
	
	public boolean isThereAFreeSpace() {
		for (int i = 0; i < parkingSpaces.length; i++) {
			if (parkingSpaces[i].isFree())
				return true;
		}
		return false;
	}
	
	public void parkTheVehicle(String regNumber) {
		if ( !isThereAFreeSpace() ) {
			System.out.println("Sorry, the parking is full");
			return;
		}
		for (int i = 0; i < parkingSpaces.length; i++) {
			if ( parkingSpaces[i].isFree() ) {
				parkingSpaces[i].setFree(false);
				parkingSpaces[i].setRegNum(regNumber);
				return; // break;
			}
		}
	}
	public boolean isTheVehicleThere(String regNumber) {
		for (int i = 0; i < parkingSpaces.length; i++) {
			if(parkingSpaces[i].isFree() == false && 
					parkingSpaces[i].getRegNum().equals(regNumber))
				return true;
		}
		return false;
	}
	
	public void removeVehicle(String regNum){
		if(isTheVehicleThere(regNum)){
			for (int i = 0; i < parkingSpaces.length; i++) {
				if(parkingSpaces[i].isFree() == false 
						&& parkingSpaces[i].getRegNum().equals(regNum)){
					parkingSpaces[i].setFree(true);
					parkingSpaces[i].setRegNum(null);
					return;
				}
			}
		}
		else{
			System.out.println("The vehicle is not parked here.");
		}
	}

}
