package labs13.task1.gui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import labs13.task1.bussiness_logic.TextDemo;

import javax.swing.JTextArea;
import javax.swing.JLabel;
import javax.swing.JTextField;
import java.awt.Dimension;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class TextEditorGUI extends JFrame {

	private JPanel contentPane;
	private JTextArea textArea;
	private JPanel panel;
	private JLabel lblFileName;
	private JTextField fileNameTxtField;
	private JButton btnLoad;
	private JButton btnDelete;
	private JButton btnSave;
	private JButton btnExit;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					TextEditorGUI frame = new TextEditorGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public TextEditorGUI() {
		setTitle("TextEditor");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 300);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
		contentPane.add(getTextArea(), BorderLayout.CENTER);
		contentPane.add(getPanel(), BorderLayout.WEST);
	}

	private JTextArea getTextArea() {
		if (textArea == null) {
			textArea = new JTextArea();
		}
		return textArea;
	}
	private JPanel getPanel() {
		if (panel == null) {
			panel = new JPanel();
			panel.setPreferredSize(new Dimension(100, 10));
			panel.add(getLblFileName());
			panel.add(getFileNameTxtField());
			panel.add(getBtnLoad());
			panel.add(getBtnDelete());
			panel.add(getBtnSave());
			panel.add(getBtnExit());
		}
		return panel;
	}
	private JLabel getLblFileName() {
		if (lblFileName == null) {
			lblFileName = new JLabel("File name:");
		}
		return lblFileName;
	}
	private JTextField getFileNameTxtField() {
		if (fileNameTxtField == null) {
			fileNameTxtField = new JTextField();
			fileNameTxtField.setPreferredSize(new Dimension(70, 20));
			fileNameTxtField.setColumns(7);
		}
		return fileNameTxtField;
	}
	private JButton getBtnLoad() {
		if (btnLoad == null) {
			btnLoad = new JButton("Load");
			btnLoad.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String fileName = fileNameTxtField.getText();
					TextDemo demo = new TextDemo();
					String text = demo.readTextFromFile(fileName);
					if ( text != null )
						textArea.setText(text);
					else textArea.setText("Error occured while reading from file");
				}
			});
			btnLoad.setPreferredSize(new Dimension(70, 23));
		}
		return btnLoad;
	}
	private JButton getBtnDelete() {
		if (btnDelete == null) {
			btnDelete = new JButton("Delete");
			btnDelete.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					textArea.setText("");
				}
			});
			btnDelete.setPreferredSize(new Dimension(70, 23));
		}
		return btnDelete;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String fileName = fileNameTxtField.getText();
					String text = textArea.getText();
					TextDemo demo = new TextDemo();
					demo.writeTextToFile(fileName, text);
				}
			});
			btnSave.setPreferredSize(new Dimension(70, 23));
		}
		return btnSave;
	}
	private JButton getBtnExit() {
		if (btnExit == null) {
			btnExit = new JButton("Exit");
			btnExit.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					System.exit(0);
				}
			});
			btnExit.setPreferredSize(new Dimension(70, 23));
		}
		return btnExit;
	}
}
