package year2012.assignment5;

import java.io.Serializable;

public class Region implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String name;
	private int birthRate;
	private int deathRate;
	private int migrationBalance;
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		if ( name == null )
			throw new DemographyException("name of the region must not be null");
		
		int letterCounter = 0;
		for (int i = 0; i < name.length(); i++) {
			if ( Character.isLetter( name.charAt(i)) ) {
				letterCounter++;
				if ( letterCounter == 2 ) {
					this.name = name;
					return;
				}
			}
		}
		// letterCounter < 2
		throw new DemographyException("name of the region must contain at least 2 letters");
		
	}
	
	public int getBirthRate() {
		return birthRate;
	}
	
	public void setBirthRate(int birthRate) {
		if ( birthRate > 0 )
			this.birthRate = birthRate;
		else throw new DemographyException("Birthrate must be a positive number");
	}
	
	public int getDeathRate() {
		return deathRate;
	}
	
	public void setDeathRate(int deathRate) {
		if ( deathRate > 0 )
			this.deathRate = deathRate;
		else throw new DemographyException("Deathrate must be a positive number");
	}
	
	public int getMigrationBalance() {
		return migrationBalance;
	}
	
	public void setMigrationBalance(int migrationBalance) {
		this.migrationBalance = migrationBalance;
	}
	
	public int computeChangeInPopSize() {
		return getBirthRate() - getDeathRate() + getMigrationBalance();
	}
	
	@Override
	public String toString() {
		return "Region: " + getName() + "; birth rate: " + getBirthRate() +
				"; death rate: " + getDeathRate() + "; change in population size: " +
				computeChangeInPopSize();
	}
	
	@Override
	public boolean equals(Object obj) {
		if ( obj instanceof Region ) {
		
			Region r = (Region)obj;
			if ( r.getName().equals(this.getName()) )
				return true;
			else return false;
			
		} else return false;
	}
	

}
