package year2012.assignment5;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.util.LinkedList;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JTextArea;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.awt.event.ActionEvent;

public class RegionsGUI extends JFrame {

	private JPanel contentPane;
	private JTextArea textArea;
	private JPanel westPanel;
	private JPanel southPanel;
	private JLabel lblName;
	private JTextField nameTxtField;
	private JLabel lblBirthRate;
	private JTextField birthRateTextField;
	private JLabel lblDeathRate;
	private JTextField deathRateTextField;
	private JLabel lblMigrationBalance;
	private JTextField mbTextField;
	private JButton btnAdd;
	private JButton btnSave;
	private JButton btnDelete;
	
	private LinkedList<Region> regions = new LinkedList<Region>();

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					RegionsGUI frame = new RegionsGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public RegionsGUI() {
		setTitle("Regional demographic data");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 506, 337);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
		contentPane.add(getTextArea(), BorderLayout.CENTER);
		contentPane.add(getWestPanel(), BorderLayout.WEST);
		contentPane.add(getSouthPanel(), BorderLayout.SOUTH);
	}

	private JTextArea getTextArea() {
		if (textArea == null) {
			textArea = new JTextArea();
		}
		return textArea;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setPreferredSize(new Dimension(110, 10));
			westPanel.setLayout(null);
			westPanel.add(getLblName());
			westPanel.add(getNameTxtField());
			westPanel.add(getLblBirthRate());
			westPanel.add(getBirthRateTextField());
			westPanel.add(getLblDeathRate());
			westPanel.add(getDeathRateTextField());
			westPanel.add(getLblMigrationBalance());
			westPanel.add(getMbTextField());
		}
		return westPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.add(getBtnAdd());
			southPanel.add(getBtnSave());
			southPanel.add(getBtnDelete());
		}
		return southPanel;
	}
	private JLabel getLblName() {
		if (lblName == null) {
			lblName = new JLabel("Name:");
			lblName.setBounds(10, 11, 70, 14);
		}
		return lblName;
	}
	private JTextField getNameTxtField() {
		if (nameTxtField == null) {
			nameTxtField = new JTextField();
			nameTxtField.setBounds(10, 36, 86, 20);
			nameTxtField.setColumns(10);
		}
		return nameTxtField;
	}
	private JLabel getLblBirthRate() {
		if (lblBirthRate == null) {
			lblBirthRate = new JLabel("Birth rate:");
			lblBirthRate.setBounds(10, 67, 90, 14);
		}
		return lblBirthRate;
	}
	private JTextField getBirthRateTextField() {
		if (birthRateTextField == null) {
			birthRateTextField = new JTextField();
			birthRateTextField.setBounds(10, 92, 86, 20);
			birthRateTextField.setColumns(10);
		}
		return birthRateTextField;
	}
	private JLabel getLblDeathRate() {
		if (lblDeathRate == null) {
			lblDeathRate = new JLabel("Death rate:");
			lblDeathRate.setBounds(10, 123, 70, 14);
		}
		return lblDeathRate;
	}
	private JTextField getDeathRateTextField() {
		if (deathRateTextField == null) {
			deathRateTextField = new JTextField();
			deathRateTextField.setBounds(10, 148, 86, 20);
			deathRateTextField.setColumns(10);
		}
		return deathRateTextField;
	}
	private JLabel getLblMigrationBalance() {
		if (lblMigrationBalance == null) {
			lblMigrationBalance = new JLabel("Migration balance");
			lblMigrationBalance.setBounds(10, 179, 90, 14);
		}
		return lblMigrationBalance;
	}
	private JTextField getMbTextField() {
		if (mbTextField == null) {
			mbTextField = new JTextField();
			mbTextField.setBounds(10, 204, 86, 20);
			mbTextField.setColumns(10);
		}
		return mbTextField;
	}
	private JButton getBtnAdd() {
		if (btnAdd == null) {
			btnAdd = new JButton("Add");
			btnAdd.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					
					String name = nameTxtField.getText();
					Region region = new Region();
					region.setName(name);
					if ( regions.contains(region) ) {
						textArea.setText("ERROR!");
						return;
					}
					
					try {
						String birthrateStr =  birthRateTextField.getText();
						region.setBirthRate( Integer.parseInt(birthrateStr));
						String deathrateStr = deathRateTextField.getText();
						region.setDeathRate( Integer.parseInt(deathrateStr));
						String mb = mbTextField.getText();
						region.setMigrationBalance(Integer.parseInt(mb));
					} catch (NumberFormatException e1) {
						textArea.setText("ERROR");
						return;
					}
					
					for (int i = 0; i < regions.size(); i++) {
						if ( region.getBirthRate() > regions.get(i).getBirthRate() ){
							regions.add(i, region);
							return;
						}
					}
					
					regions.addLast(region);
				}
			});
			btnAdd.setPreferredSize(new Dimension(65, 25));
		}
		return btnAdd;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					
					try(ObjectOutputStream gOut = 
							new ObjectOutputStream(
									new FileOutputStream("growing_regions.out"));
							ObjectOutputStream dOut = 
									new ObjectOutputStream(
											new FileOutputStream("dying_regions.out"))){
						
						for (Region region : regions) {
							if ( region.computeChangeInPopSize() > 0 )
								gOut.writeObject(region);
							else dOut.writeObject(region);
						}
						
					} catch (IOException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
				}
			});
			btnSave.setPreferredSize(new Dimension(65, 25));
		}
		return btnSave;
	}
	private JButton getBtnDelete() {
		if (btnDelete == null) {
			btnDelete = new JButton("Delete");
			btnDelete.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					nameTxtField.setText("");
					birthRateTextField.setText("");
					deathRateTextField.setText("");
					mbTextField.setText("");
					textArea.setText("");
				}
			});
			btnDelete.setPreferredSize(new Dimension(65, 25));
		}
		return btnDelete;
	}
}
