package labs13.task1.gui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import labs13.task1.bussiness_logic.TextDemo;

import javax.swing.JTextArea;
import javax.swing.JLabel;
import javax.swing.JTextField;
import java.awt.Dimension;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class TextEditorGUI extends JFrame {

	private JPanel contentPane;
	private JTextArea textArea;
	private JPanel westPanel;
	private JLabel lblNewLabel;
	private JTextField fileNametxtField;
	private JButton btnLoad;
	private JButton btnDelete;
	private JButton btnSave;
	private JButton btnExit;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					TextEditorGUI frame = new TextEditorGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public TextEditorGUI() {
		setTitle("TextEditor");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 300);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
		contentPane.add(getTextArea(), BorderLayout.CENTER);
		contentPane.add(getWestPanel(), BorderLayout.WEST);
	}

	private JTextArea getTextArea() {
		if (textArea == null) {
			textArea = new JTextArea();
		}
		return textArea;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setPreferredSize(new Dimension(100, 10));
			westPanel.add(getLblNewLabel());
			westPanel.add(getFileNametxtField());
			westPanel.add(getBtnLoad());
			westPanel.add(getBtnDelete());
			westPanel.add(getBtnSave());
			westPanel.add(getBtnExit());
		}
		return westPanel;
	}
	private JLabel getLblNewLabel() {
		if (lblNewLabel == null) {
			lblNewLabel = new JLabel("File name:");
		}
		return lblNewLabel;
	}
	private JTextField getFileNametxtField() {
		if (fileNametxtField == null) {
			fileNametxtField = new JTextField();
			fileNametxtField.setColumns(8);
		}
		return fileNametxtField;
	}
	private JButton getBtnLoad() {
		if (btnLoad == null) {
			btnLoad = new JButton("Load");
			btnLoad.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String fileName = fileNametxtField.getText();
					TextDemo demo = new TextDemo();
					String text = demo.readTextFromFile(fileName);
					if ( text != null )
						textArea.setText(text);
					else
						textArea.setText("ERROR occured while reading text from file");
				}
			});
			btnLoad.setPreferredSize(new Dimension(90, 23));
		}
		return btnLoad;
	}
	private JButton getBtnDelete() {
		if (btnDelete == null) {
			btnDelete = new JButton("Delete");
			btnDelete.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					textArea.setText("");
				}
			});
			btnDelete.setPreferredSize(new Dimension(90, 23));
		}
		return btnDelete;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String fileName = fileNametxtField.getText();
					String text = textArea.getText();
					TextDemo demo = new TextDemo();
					demo.writeTextToFile(text, fileName);
				}
			});
			btnSave.setPreferredSize(new Dimension(90, 23));
		}
		return btnSave;
	}
	private JButton getBtnExit() {
		if (btnExit == null) {
			btnExit = new JButton("Exit");
			btnExit.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					System.exit(0);
				}
			});
			btnExit.setPreferredSize(new Dimension(90, 23));
		}
		return btnExit;
	}
}
