/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.DomainException;
import don.KnowledgeElement;
import java.io.Serializable;

class Domain
extends KnowledgeElement
implements Serializable {
    protected String type;
    protected double MAX;
    protected double MIN;
    protected int MAXL;
    protected int MINL;
    protected boolean BMAX = false;
    protected boolean BMIN = false;
    protected boolean BMAXL = false;
    protected boolean BMINL = false;

    Domain() {
    }

    Domain(String name, String type, String[] restrictions) throws Exception {
        super(name);
        if (name == null) {
            throw new DomainException(1, name);
        }
        this.name = name.trim();
        if (type == null) {
            throw new DomainException(2, type);
        }
        if (type.trim().equalsIgnoreCase("integer")) {
            this.type = "integer";
        } else if (type.trim().equalsIgnoreCase("float")) {
            this.type = "float";
        } else if (type.trim().equalsIgnoreCase("boolean")) {
            this.type = "boolean";
        } else if (type.trim().equalsIgnoreCase("string")) {
            this.type = "string";
        } else {
            throw new DomainException(3, type);
        }
        if (restrictions == null) {
            this.BMINL = false;
            this.BMAXL = false;
            this.BMIN = false;
            this.BMAX = false;
        } else {
            if (restrictions.length != 4) {
                throw new DomainException(4, null);
            }
            if (restrictions[0] == null || restrictions[0].equalsIgnoreCase("")) {
                this.BMAX = false;
            } else {
                try {
                    this.MAX = Double.parseDouble(restrictions[0]);
                    this.BMAX = true;
                }
                catch (Exception e) {
                    throw new DomainException(40, restrictions[0]);
                }
            }
            if (restrictions[1] == null || restrictions[1].equalsIgnoreCase("")) {
                this.BMIN = false;
            } else {
                try {
                    this.MIN = Double.parseDouble(restrictions[1]);
                    this.BMIN = true;
                }
                catch (Exception e) {
                    throw new DomainException(41, restrictions[1]);
                }
            }
            if (restrictions[2] == null || restrictions[2].equalsIgnoreCase("")) {
                this.BMAXL = false;
            } else {
                try {
                    this.MAXL = Integer.parseInt(restrictions[2]);
                    this.BMAXL = true;
                }
                catch (Exception e) {
                    throw new DomainException(42, restrictions[2]);
                }
            }
            if (restrictions[3] == null || restrictions[3].equalsIgnoreCase("")) {
                this.BMINL = false;
            } else {
                try {
                    this.MINL = Integer.parseInt(restrictions[3]);
                    this.BMINL = true;
                }
                catch (Exception e) {
                    throw new DomainException(43, restrictions[3]);
                }
            }
            if (this.BMAX && this.BMIN && this.MAX < this.MIN) {
                throw new DomainException(5, null);
            }
            if (this.BMAXL && this.BMINL && this.MAXL < this.MINL) {
                throw new DomainException(6, null);
            }
        }
    }

    String GetType() {
        return this.type;
    }

    String[] GetRestrictions() {
        String[] res = new String[4];
        if (this.BMAX) {
            res[0] = String.valueOf(this.MAX);
        }
        if (this.BMIN) {
            res[1] = String.valueOf(this.MIN);
        }
        if (this.BMAXL) {
            res[2] = String.valueOf(this.MAXL);
        }
        if (this.BMINL) {
            res[3] = String.valueOf(this.MINL);
        }
        return res;
    }

    void SetType(String type) throws Exception {
        if (type == null) {
            throw new DomainException(2, type);
        }
        if (type.trim().equalsIgnoreCase("integer")) {
            this.type = "integer";
        } else if (type.trim().equalsIgnoreCase("float")) {
            this.type = "float";
        } else if (type.trim().equalsIgnoreCase("boolean")) {
            this.type = "boolean";
        } else if (type.trim().equalsIgnoreCase("string")) {
            this.type = "string";
        } else {
            throw new DomainException(3, type);
        }
    }

    void SetRestrictions(String[] restrictions) throws Exception {
        if (restrictions == null) {
            this.BMINL = false;
            this.BMAXL = false;
            this.BMIN = false;
            this.BMAX = false;
        } else {
            if (restrictions.length != 4) {
                throw new DomainException(4, null);
            }
            if (restrictions[0] == null || restrictions[0].equalsIgnoreCase("")) {
                this.BMAX = false;
            } else {
                try {
                    this.MAX = Double.parseDouble(restrictions[0]);
                    this.BMAX = true;
                }
                catch (Exception e) {
                    throw new DomainException(40, restrictions[0]);
                }
            }
            if (restrictions[1] == null || restrictions[1].equalsIgnoreCase("")) {
                this.BMIN = false;
            } else {
                try {
                    this.MIN = Double.parseDouble(restrictions[1]);
                    this.BMIN = true;
                }
                catch (Exception e) {
                    throw new DomainException(41, restrictions[1]);
                }
            }
            if (restrictions[2] == null || restrictions[2].equalsIgnoreCase("")) {
                this.BMAXL = false;
            } else {
                try {
                    this.MAXL = Integer.parseInt(restrictions[2]);
                    this.BMAXL = true;
                }
                catch (Exception e) {
                    throw new DomainException(42, restrictions[2]);
                }
            }
            if (restrictions[3] == null || restrictions[3].equalsIgnoreCase("")) {
                this.BMINL = false;
            } else {
                try {
                    this.MINL = Integer.parseInt(restrictions[3]);
                    this.BMINL = true;
                }
                catch (Exception e) {
                    throw new DomainException(43, restrictions[3]);
                }
            }
            if (this.BMAX && this.BMIN && this.MAX < this.MIN) {
                throw new DomainException(5, null);
            }
            if (this.BMAXL && this.BMINL && this.MAXL < this.MINL) {
                throw new DomainException(6, null);
            }
        }
    }

    void IsValidValue(String value) throws Exception {
        if (value == null) {
            throw new DomainException(7, null);
        }
        if (this.type.equals("integer")) {
            int pom;
            try {
                pom = Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new DomainException(8, value);
            }
            if (this.BMAX && (double)pom > this.MAX) {
                throw new DomainException(81, String.valueOf(this.MAX));
            }
            if (this.BMIN && (double)pom < this.MIN) {
                throw new DomainException(82, String.valueOf(this.MIN));
            }
        }
        if (this.type.equals("float")) {
            double pom;
            try {
                pom = Double.parseDouble(value);
            }
            catch (Exception e) {
                throw new DomainException(9, value);
            }
            if (this.BMAX && pom > this.MAX) {
                throw new DomainException(81, String.valueOf(this.MAX));
            }
            if (this.BMIN && pom < this.MIN) {
                throw new DomainException(82, String.valueOf(this.MIN));
            }
        }
        if (this.type.equals("string")) {
            if (this.BMAXL && value.length() > this.MAXL) {
                throw new DomainException(101, String.valueOf(this.MAXL));
            }
            if (this.BMINL && value.length() < this.MINL) {
                throw new DomainException(102, String.valueOf(this.MINL));
            }
        }
        if (this.type.equals("boolean") && !value.trim().equalsIgnoreCase("true") && !value.trim().equalsIgnoreCase("false")) {
            throw new DomainException(11, value);
        }
    }

    String[][] GetDomain() {
        String[][] pom = new String[3][0];
        pom[0] = new String[1];
        pom[0][0] = this.GetName();
        pom[1] = new String[1];
        pom[1][0] = this.GetType();
        pom[2] = this.GetRestrictions();
        return pom;
    }
}

