/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Attribute;
import don.FramEException;
import don.KnowledgeElement;
import don.Slot;
import don.Subframe;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

class FramE
extends KnowledgeElement
implements Serializable {
    LinkedList subframes = new LinkedList();
    LinkedList parentframes = new LinkedList();
    LinkedList slots = new LinkedList();

    FramE() {
    }

    FramE(String name) throws Exception {
        super(name);
        if (name == null) {
            throw new FramEException(1, null);
        }
        this.name = name.trim();
    }

    String[][][] GetAttributes() {
        LinkedList<String[][]> pom1 = new LinkedList<String[][]>();
        LinkedList pom11 = new LinkedList();
        pom11.addAll(this.GetFrameSlots());
        pom11.addAll(this.GetParentFrameSlots());
        for (String[][] s1 : pom11) {
            Iterator j = pom1.iterator();
            boolean ind = true;
            while (j.hasNext() && ind) {
                String[][] s2 = (String[][])j.next();
                if (!s1[1][0].equals(s2[1][0])) continue;
                ind = false;
            }
            if (!ind) continue;
            pom1.addLast(s1);
        }
        Object[] pom2 = pom1.toArray();
        String[][][] pom = new String[pom2.length][0][0];
        for (int l = 0; l < pom2.length; ++l) {
            pom[l] = (String[][])pom2[l];
        }
        return pom;
    }

    void AddSlot(Attribute attributeref, String[] question, String description) throws Exception {
        if (attributeref == null) {
            throw new FramEException(21, null);
        }
        if (this.HasSlot(attributeref.GetName())) {
            throw new FramEException(22, attributeref.GetName());
        }
        if (this.ParentHasSlot(attributeref.GetName())) {
            throw new FramEException(23, attributeref.GetName());
        }
        Slot pom = new Slot(attributeref, question, description);
        this.slots.addLast(pom);
    }

    void DeleteSlotWithAttribute(String attribute) {
        if (attribute != null) {
            Iterator i = this.slots.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                Slot s = (Slot)o;
                if (!s.GetAttributeName().equals(attribute)) continue;
                i.remove();
            }
        }
    }

    void DeleteSlot(String attribute) throws Exception {
        if (attribute == null) {
            throw new FramEException(31, null);
        }
        if (this.ParentHasSlot(attribute)) {
            throw new FramEException(32, attribute);
        }
        if (!this.HasSlot(attribute)) {
            throw new FramEException(33, attribute);
        }
        Iterator i = this.slots.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            Slot s = (Slot)o;
            if (!s.GetAttributeName().equals(attribute)) continue;
            i.remove();
        }
    }

    void DeleteSlotsWithDomain(String domain) {
        if (domain != null) {
            Iterator i = this.slots.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                Slot s = (Slot)o;
                String pom = s.GetAttributeDomain();
                if (pom == null || !pom.equals(domain)) continue;
                i.remove();
            }
        }
    }

    void DeleteSubframeWithFrame(String frame) {
        if (frame != null) {
            Iterator i = this.subframes.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                Subframe s = (Subframe)o;
                String pom = s.GetFrameName();
                if (!pom.equals(frame)) continue;
                i.remove();
            }
        }
    }

    void DeleteParentFrame(String frame) throws Exception {
        if (frame == null) {
            throw new FramEException(4, null);
        }
        if (!this.HasDirectParent(frame)) {
            throw new FramEException(5, frame);
        }
        Iterator i = this.parentframes.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            FramE s = (FramE)o;
            String pom = s.GetName();
            if (!pom.equals(frame.trim())) continue;
            i.remove();
            break;
        }
    }

    void DeleteParentFrameWithFrame(String frame) {
        if (frame != null) {
            Iterator i = this.parentframes.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                FramE s = (FramE)o;
                String pom = s.GetName();
                if (!pom.equals(frame.trim())) continue;
                i.remove();
                break;
            }
        }
    }

    void AddParentFrame(FramE parentframeref) throws Exception {
        if (parentframeref == null) {
            throw new FramEException(40, null);
        }
        if (parentframeref.GetName().equals(this.GetName())) {
            throw new FramEException(41, null);
        }
        if (this.HasParentFrame(parentframeref.GetName())) {
            throw new FramEException(42, parentframeref.GetName());
        }
        if (parentframeref.HasParentFrame(this.name)) {
            throw new FramEException(43, parentframeref.GetName());
        }
        if (this.CheckSubframes(parentframeref)) {
            throw new FramEException(44, parentframeref.GetName());
        }
        this.parentframes.addLast(parentframeref);
    }

    void AddSubframe(String subframe, FramE baseframeref, String multiplicity) throws Exception {
        if (subframe == null) {
            throw new FramEException(51, subframe);
        }
        if (this.HasSubframe(subframe)) {
            throw new FramEException(52, subframe);
        }
        if (this.ParentHasSubframe(subframe)) {
            throw new FramEException(53, subframe);
        }
        if (baseframeref == this) {
            throw new FramEException(54, null);
        }
        if (baseframeref.HasParentFrame(this.name)) {
            throw new FramEException(55, null);
        }
        String[][] pom = baseframeref.GetSubframes();
        for (int i = 0; i < pom.length; ++i) {
            if (!pom[i][1].equals(this.name)) continue;
            throw new FramEException(56, baseframeref.GetName());
        }
        Subframe s = new Subframe(subframe, baseframeref, multiplicity);
        this.subframes.addLast(s);
    }

    void DeleteSubframe(String subframe) throws Exception {
        if (subframe == null) {
            throw new FramEException(61, null);
        }
        if (this.ParentHasSubframe(subframe)) {
            throw new FramEException(62, subframe);
        }
        if (!this.HasSubframe(subframe)) {
            throw new FramEException(63, subframe);
        }
        Iterator i = this.subframes.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            Subframe s = (Subframe)o;
            String pom = s.GetName();
            if (!pom.equals(subframe)) continue;
            i.remove();
            break;
        }
    }

    Attribute GetAttributeReference(String attribute) throws Exception {
        if (attribute == null) {
            throw new FramEException(60, null);
        }
        if (this.HasSlot(attribute)) {
            return this.GetFrameAttributeReference(attribute);
        }
        if (this.ParentHasSlot(attribute)) {
            return this.GetParentAttributeReference(attribute);
        }
        throw new FramEException(6, null);
    }

    String[][] GetSlot(String attribute) throws Exception {
        if (attribute == null) {
            throw new FramEException(71, attribute);
        }
        if (!this.HasSlot(attribute)) {
            throw new FramEException(72, attribute);
        }
        for (Object o : this.slots) {
            Slot s = (Slot)o;
            if (!s.GetAttributeName().equals(attribute)) continue;
            return s.GetSlot();
        }
        return null;
    }

    void SetSlot(Attribute attributeref, String[] question, String description, String oldattribute) throws Exception {
        if (oldattribute == null) {
            throw new FramEException(81, oldattribute);
        }
        if (!this.HasSlot(oldattribute)) {
            throw new FramEException(82, oldattribute);
        }
        if (attributeref == null) {
            throw new FramEException(21, null);
        }
        if (!attributeref.GetName().equals(oldattribute)) {
            if (this.HasSlot(attributeref.GetName())) {
                throw new FramEException(22, attributeref.GetName());
            }
            if (this.ParentHasSlot(attributeref.GetName())) {
                throw new FramEException(23, attributeref.GetName());
            }
        }
        for (Object o : this.slots) {
            Slot s = (Slot)o;
            if (!s.GetAttributeName().equals(oldattribute)) continue;
            s.SetQuestion(question);
            s.SetDescription(description);
            if (attributeref.GetName().equals(oldattribute)) break;
            s.SetAttribute(attributeref);
            break;
        }
    }

    String[][] GetSubframes() {
        LinkedList pom1 = new LinkedList();
        pom1.addAll(this.GetFrameSubframes());
        pom1.addAll(this.GetParentFrameSubframes());
        Object[] pom2 = pom1.toArray();
        String[][] pom = new String[pom2.length][0];
        for (int i = 0; i < pom2.length; ++i) {
            pom[i] = (String[])pom2[i];
        }
        return pom;
    }

    String[] GetParentFrames() {
        int j = this.parentframes.size();
        String[] pom = new String[j];
        Iterator i = this.parentframes.iterator();
        j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            FramE s = (FramE)o;
            pom[j] = s.GetName();
            ++j;
        }
        return pom;
    }

    String[] GetSubframe(String subframe) throws Exception {
        if (subframe == null) {
            throw new FramEException(91, subframe);
        }
        if (!this.HasSubframe(subframe)) {
            throw new FramEException(92, subframe);
        }
        String[] pom = null;
        for (Object o : this.subframes) {
            Subframe s = (Subframe)o;
            if (!s.GetName().equals(subframe)) continue;
            pom = s.GetSubframe();
            break;
        }
        return pom;
    }

    String[][][][][] GetAllSubframeAttributes() {
        LinkedList pom1 = new LinkedList();
        for (Object o : this.parentframes) {
            FramE s = (FramE)o;
            pom1.addAll(s.GetFrameSubframeAttributes(null));
        }
        pom1.addAll(this.GetFrameSubframeAttributes(null));
        Object[] pom2 = pom1.toArray();
        String[][][][][] pom = new String[pom2.length][0][0][0][0];
        for (int j = 0; j < pom2.length; ++j) {
            pom[j] = (String[][][][])pom2[j];
        }
        return pom;
    }

    String GetSubframeBaseframe(String subframe) {
        Serializable s;
        if (subframe == null || subframe == "") {
            return null;
        }
        for (Object o : this.subframes) {
            s = (Subframe)o;
            if (subframe.equals(((Subframe)s).GetName())) {
                return ((Subframe)s).GetFrameName();
            }
            if (subframe.startsWith(((Subframe)s).GetName() + "[") && subframe.indexOf(46) < 0) {
                return ((Subframe)s).GetFrameName();
            }
            if (subframe.startsWith(((Subframe)s).GetName() + ".")) {
                return ((Subframe)s).baseframe.GetSubframeBaseframe(new String(subframe.substring(((Subframe)s).GetName().length() + 1)));
            }
            if (!subframe.startsWith(((Subframe)s).GetName() + "[")) continue;
            return ((Subframe)s).baseframe.GetSubframeBaseframe(subframe.substring(subframe.indexOf(93) + 2));
        }
        for (Object o : this.parentframes) {
            s = (FramE)o;
            String pom = ((FramE)s).GetSubframeBaseframe(subframe);
            if (pom == null) continue;
            return pom;
        }
        return null;
    }

    FramE GetSubframeBaseframeReference(String subframe) {
        Serializable s;
        if (subframe == null || subframe == "") {
            return null;
        }
        for (Object o : this.subframes) {
            s = (Subframe)o;
            if (subframe.equals(((Subframe)s).GetName())) {
                return ((Subframe)s).baseframe;
            }
            if (subframe.startsWith(((Subframe)s).GetName() + "[") && subframe.indexOf(46) < 0) {
                return ((Subframe)s).baseframe;
            }
            if (subframe.startsWith(((Subframe)s).GetName() + ".")) {
                return ((Subframe)s).baseframe.GetSubframeBaseframeReference(new String(subframe.substring(((Subframe)s).GetName().length() + 1)));
            }
            if (!subframe.startsWith(((Subframe)s).GetName() + "[")) continue;
            return ((Subframe)s).baseframe.GetSubframeBaseframeReference(subframe.substring(subframe.indexOf(93) + 2));
        }
        for (Object o : this.parentframes) {
            s = (FramE)o;
            FramE pom = ((FramE)s).GetSubframeBaseframeReference(subframe);
            if (pom == null) continue;
            return pom;
        }
        return null;
    }

    String[][][][][][] GetFrame() {
        String[][][][][][] pom = new String[3][0][0][0][0][0];
        pom[0] = new String[1][1][1][1][1];
        pom[0][0][0][0][0][0] = this.GetName();
        pom[1] = new String[1][1][0][0][0];
        pom[1][0][0] = this.GetAttributes();
        pom[2] = this.GetAllSubframeAttributes();
        return pom;
    }

    String[][][][] GetFrame2() {
        String[][][][] pom = new String[4][0][0][0];
        pom[0] = new String[1][1][1];
        pom[0][0][0][0] = this.GetName();
        pom[1] = this.GetAttributes();
        pom[2] = new String[1][0][0];
        pom[2][0] = this.GetSubframes();
        pom[3] = new String[1][1][0];
        pom[3][0][0] = this.GetParentFrames();
        return pom;
    }

    String[][][][] GetParentFrame(String parentframe) throws Exception {
        if (parentframe == null) {
            throw new FramEException(93, null);
        }
        String[][][][] pom = null;
        Iterator i = this.parentframes.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            FramE f = (FramE)o;
            if (!f.GetName().equals(parentframe.trim())) continue;
            pom = f.GetFrame2();
            ind = true;
        }
        if (!ind) {
            throw new FramEException(94, parentframe.trim());
        }
        return pom;
    }

    void AddMedia(String name, String path, String attribute, boolean ucitavanje) throws Exception {
        if (attribute == null) {
            throw new FramEException(21, null);
        }
        Iterator i = this.slots.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Slot pom = (Slot)i.next();
            if (!pom.GetAttributeName().equals(attribute.trim())) continue;
            pom.AddMedia(name, path, ucitavanje);
            ind = true;
        }
        if (!ind) {
            throw new FramEException(33, attribute.trim());
        }
    }

    String[] GetMedia(String attribute, String media) throws Exception {
        if (attribute == null) {
            throw new FramEException(21, null);
        }
        for (Slot pom : this.slots) {
            if (!pom.GetAttributeName().equals(attribute.trim())) continue;
            return pom.GetMedia(media);
        }
        throw new FramEException(33, attribute.trim());
    }

    void DeleteMedia(String attribute, String media) throws Exception {
        if (attribute == null) {
            throw new FramEException(21, null);
        }
        Iterator i = this.slots.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Slot pom = (Slot)i.next();
            if (!pom.GetAttributeName().equals(attribute.trim())) continue;
            pom.DeleteMedia(media);
            ind = true;
        }
        if (!ind) {
            throw new FramEException(33, attribute.trim());
        }
    }

    boolean HasSlot(String attribute) {
        for (Object o : this.slots) {
            Slot s = (Slot)o;
            if (!s.GetAttributeName().equals(attribute)) continue;
            return true;
        }
        return false;
    }

    boolean ParentHasSlot(String attribute) {
        Iterator i = this.parentframes.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            FramE f = (FramE)o;
            if (!f.HasSlot(attribute) && !f.ParentHasSlot(attribute)) continue;
            ind = true;
        }
        return ind;
    }

    boolean HasParentFrame(String frame) {
        Iterator i = this.parentframes.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            FramE s = (FramE)o;
            if (!frame.equals(s.GetName()) && !s.HasParentFrame(frame)) continue;
            ind = true;
        }
        return ind;
    }

    boolean HasSubframe(String subframe) {
        Iterator i = this.subframes.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            Subframe s = (Subframe)o;
            if (!s.GetName().equals(subframe)) continue;
            ind = true;
        }
        return ind;
    }

    boolean ParentHasSubframe(String subframe) {
        Iterator i = this.parentframes.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            FramE f = (FramE)o;
            if (!f.HasSubframe(subframe) && !f.ParentHasSubframe(subframe)) continue;
            ind = true;
        }
        return ind;
    }

    Attribute GetParentAttributeReference(String attribute) {
        Object o;
        FramE f;
        Iterator i = this.parentframes.iterator();
        Attribute pom = null;
        while (i.hasNext() && (pom = (f = (FramE)(o = i.next())).GetFrameAttributeReference(attribute)) == null && (pom = f.GetParentAttributeReference(attribute)) == null) {
        }
        return pom;
    }

    Attribute GetFrameAttributeReference(String attribute) {
        for (Object o : this.slots) {
            Slot s = (Slot)o;
            if (!s.GetAttributeName().equals(attribute)) continue;
            return s.GetAttributeReference();
        }
        return null;
    }

    boolean HasDirectParent(String frame) {
        Iterator i = this.parentframes.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            FramE s = (FramE)o;
            if (!frame.equals(s.GetName())) continue;
            ind = true;
        }
        return ind;
    }

    LinkedList GetFrameSlots() {
        Iterator i = this.slots.iterator();
        LinkedList<String[][]> l = new LinkedList<String[][]>();
        while (i.hasNext()) {
            Object o = i.next();
            Slot s = (Slot)o;
            l.addLast(s.GetSlot());
        }
        return l;
    }

    LinkedList GetParentFrameSlots() {
        Iterator i = this.parentframes.iterator();
        LinkedList l = new LinkedList();
        while (i.hasNext()) {
            Object o = i.next();
            FramE f = (FramE)o;
            l.addAll(f.GetFrameSlots());
            l.addAll(f.GetParentFrameSlots());
        }
        return l;
    }

    LinkedList GetFrameSubframes() {
        Iterator i = this.subframes.iterator();
        LinkedList<String[]> l = new LinkedList<String[]>();
        while (i.hasNext()) {
            Object o = i.next();
            Subframe s = (Subframe)o;
            l.addLast(s.GetSubframe());
        }
        return l;
    }

    LinkedList GetParentFrameSubframes() {
        Iterator i = this.parentframes.iterator();
        LinkedList l = new LinkedList();
        while (i.hasNext()) {
            Object o = i.next();
            FramE f = (FramE)o;
            l.addAll(f.GetFrameSubframes());
            l.addAll(f.GetParentFrameSubframes());
        }
        return l;
    }

    boolean CheckSubframes(FramE frame) {
        int i;
        LinkedList pom1 = new LinkedList();
        LinkedList pom2 = new LinkedList();
        pom1.addAll(this.GetFrameSubframes());
        pom1.addAll(this.GetParentFrameSubframes());
        pom2.addAll(frame.GetFrameSubframes());
        pom2.addAll(frame.GetParentFrameSubframes());
        Object[] pom3 = pom1.toArray();
        String[][] niz1 = new String[pom3.length][0];
        for (i = 0; i < pom3.length; ++i) {
            niz1[i] = (String[])pom3[i];
        }
        pom3 = pom2.toArray();
        String[][] niz2 = new String[pom3.length][0];
        for (i = 0; i < pom3.length; ++i) {
            niz2[i] = (String[])pom3[i];
        }
        for (i = 0; i < niz1.length; ++i) {
            for (int j = 0; j < niz2.length; ++j) {
                if (!niz1[i][0].equals(niz2[j][0])) continue;
                return true;
            }
        }
        return false;
    }

    LinkedList GetFrameSubframeAttributes(String subframe) {
        Iterator i = this.subframes.iterator();
        LinkedList<String[][][][]> l = new LinkedList<String[][][][]>();
        while (i.hasNext()) {
            Object o = i.next();
            Subframe s = (Subframe)o;
            String[] pom2 = s.GetSubframe();
            int m = Integer.parseInt(pom2[2]);
            if (m > 1) {
                for (int j = 0; j < m; ++j) {
                    String[][][][] pom = new String[2][0][0][0];
                    pom[0] = new String[1][1][0];
                    pom[0][0][0] = s.GetSubframe();
                    pom[0][0][0][0] = subframe != null ? subframe + "." + pom[0][0][0][0] + "[" + j + "]" : pom[0][0][0][0] + "[" + j + "]";
                    pom[1] = s.GetAttributes();
                    l.addLast(pom);
                    l.addAll(s.baseframe.GetFrameSubframeAttributes(pom[0][0][0][0]));
                }
                continue;
            }
            String[][][][] pom = new String[2][0][0][0];
            pom[0] = new String[1][1][0];
            pom[0][0][0] = s.GetSubframe();
            if (subframe != null) {
                pom[0][0][0][0] = subframe + "." + pom[0][0][0][0];
            }
            pom[1] = s.GetAttributes();
            l.addLast(pom);
            l.addAll(s.baseframe.GetFrameSubframeAttributes(pom[0][0][0][0]));
        }
        return l;
    }
}

