/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Attribute;
import don.Formula;
import don.FramE;
import don.KnowledgeChunk;
import don.KnowledgeElements;
import don.Relation;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.LinkedList;

class Knowledge
implements Serializable {
    KnowledgeElements domains = new KnowledgeElements();
    KnowledgeElements attributes = new KnowledgeElements();
    KnowledgeElements frames = new KnowledgeElements();
    KnowledgeElements rules = new KnowledgeElements();
    KnowledgeElements formulas = new KnowledgeElements();
    KnowledgeElements actions = new KnowledgeElements();
    KnowledgeElements relations = new KnowledgeElements();
    KnowledgeElements chunks = new KnowledgeElements();

    Knowledge() {
        ObjectInputStream in;
        File f;
        try {
            f = new File("actions.dat");
            if (f.exists()) {
                in = new ObjectInputStream(new FileInputStream(f));
                try {
                    while (true) {
                        this.actions.elements.addLast(in.readObject());
                    }
                }
                catch (Exception e) {
                    in.close();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            f = new File("relations.dat");
            if (f.exists()) {
                in = new ObjectInputStream(new FileInputStream(f));
                try {
                    while (true) {
                        this.relations.elements.addLast(in.readObject());
                    }
                }
                catch (Exception e) {
                    in.close();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            f = new File("formulas.dat");
            if (f.exists()) {
                in = new ObjectInputStream(new FileInputStream(f));
                try {
                    while (true) {
                        this.formulas.elements.addLast(in.readObject());
                    }
                }
                catch (Exception e) {
                    in.close();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.domains.AddDomain("STRING", "string", null);
            this.domains.AddDomain("INTEGER", "integer", null);
            this.domains.AddDomain("FLOAT", "float", null);
            this.domains.AddDomain("BOOLEAN", "boolean", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String[][][] GetAllDomains() throws Exception {
        return this.domains.GetAllDomains();
    }

    void AddAttribute(String name, String domain) throws Exception {
        this.attributes.AddAttribute(name, this.domains.GetDomainReference(domain));
    }

    String[][][][][][][] GetAllFrames() throws Exception {
        return this.frames.GetAllFrames();
    }

    String[][] GetAllRelations() throws Exception {
        return this.relations.GetAllRelations();
    }

    String[][] GetAllFormulas() throws Exception {
        return this.formulas.GetAllFormulas();
    }

    String[][] GetAllActions() throws Exception {
        return this.actions.GetAllActions();
    }

    void AddDomain(String name, String type, String[] restrictions) throws Exception {
        this.domains.AddDomain(name, type, restrictions);
    }

    void AddFrame(String frame) throws Exception {
        this.frames.AddFrame(frame);
    }

    String[] GetAllChunks() throws Exception {
        return this.chunks.GetAllChunks();
    }

    String[][][] GetAllChunks2() throws Exception {
        return this.chunks.GetAllChunks2();
    }

    void AddIfClause(String rule, String chunk) throws Exception {
        this.rules.AddIfClause(rule, this.chunks.GetChunkReference(chunk));
    }

    void AddOAAcChunk(String frame, String subframe, String attribute, String action) throws Exception {
        this.chunks.AddOAAcChunk(this.frames.GetFrameReference(frame), subframe, this.attributes.GetAttributeReference(attribute), this.actions.GetActionReference(action));
    }

    void AddOAAcChunk(String name, String frame, String subframe, String attribute, String action) throws Exception {
        this.chunks.AddOAAcChunk(name, this.frames.GetFrameReference(frame), subframe, this.attributes.GetAttributeReference(attribute), this.actions.GetActionReference(action));
    }

    void AddOARFChunk(String frame, String subframe, String attribute, String relation, String formula, String[][][] arguments) throws Exception {
        FramE frameref = this.frames.GetFrameReference(frame);
        Attribute attributeref = this.attributes.GetAttributeReference(attribute);
        Relation relationref = this.relations.GetRelationReference(relation);
        Formula formularef = this.formulas.GetFormulaReference(formula);
        Object[][] argumentsref = null;
        if (arguments != null) {
            int i;
            argumentsref = new Object[arguments.length][0];
            for (i = 0; i < argumentsref.length; ++i) {
                argumentsref[i] = null;
            }
            for (i = 0; i < arguments.length; ++i) {
                if (arguments[i] != null) {
                    if (arguments[i].length == 1 && arguments[i][0].length == 3) {
                        argumentsref[i] = new Object[3];
                        argumentsref[i][0] = this.frames.GetFrameReference(arguments[i][0][0]);
                        argumentsref[i][1] = arguments[i][0][1];
                        argumentsref[i][2] = this.attributes.GetAttributeReference(arguments[i][0][2]);
                        continue;
                    }
                    argumentsref[i] = new Object[1];
                    argumentsref[i][0] = arguments[i];
                    continue;
                }
                throw new Exception("You must enter arg" + (i + 1));
            }
        }
        String[][] s = null;
        if (attributeref != null) {
            s = attributeref.GetDomain();
        }
        String s2 = null;
        if (s != null) {
            s2 = s[1][0];
        }
        formularef.CheckArguments(s2, argumentsref);
        this.chunks.AddOARFChunk(frameref, subframe, attributeref, relationref, formularef, argumentsref);
    }

    void AddOARFChunk(String name, String frame, String subframe, String attribute, String relation, String formula, String[][][] arguments) throws Exception {
        FramE frameref = this.frames.GetFrameReference(frame);
        Attribute attributeref = this.attributes.GetAttributeReference(attribute);
        Relation relationref = this.relations.GetRelationReference(relation);
        Formula formularef = this.formulas.GetFormulaReference(formula);
        Object[][] argumentsref = null;
        if (arguments != null) {
            int i;
            argumentsref = new Object[arguments.length][0];
            for (i = 0; i < argumentsref.length; ++i) {
                argumentsref[i] = null;
            }
            for (i = 0; i < arguments.length; ++i) {
                if (arguments[i] != null) {
                    if (arguments[i].length == 1 && arguments[i][0].length == 3) {
                        argumentsref[i] = new Object[3];
                        argumentsref[i][0] = this.frames.GetFrameReference(arguments[i][0][0]);
                        argumentsref[i][1] = arguments[i][0][1];
                        argumentsref[i][2] = this.attributes.GetAttributeReference(arguments[i][0][2]);
                        continue;
                    }
                    argumentsref[i] = new Object[1];
                    argumentsref[i][0] = arguments[i];
                    continue;
                }
                throw new Exception("You must enter arg" + (i + 1));
            }
        }
        String[][] s = null;
        if (attributeref != null) {
            s = attributeref.GetDomain();
        }
        String s2 = null;
        if (s != null) {
            s2 = s[1][0];
        }
        formularef.CheckArguments(s2, argumentsref);
        this.chunks.AddOARFChunk(name, frameref, subframe, attributeref, relationref, formularef, argumentsref);
    }

    void AddOAROAChunk(String frame, String subframe, String attribute, String relation, String frame2, String subframe2, String attribute2) throws Exception {
        this.chunks.AddOAROAChunk(this.frames.GetFrameReference(frame), subframe, this.attributes.GetAttributeReference(attribute), this.relations.GetRelationReference(relation), this.frames.GetFrameReference(frame2), subframe2, this.attributes.GetAttributeReference(attribute2));
    }

    void AddOAROAChunk(String name, String frame, String subframe, String attribute, String relation, String frame2, String subframe2, String attribute2) throws Exception {
        this.chunks.AddOAROAChunk(name, this.frames.GetFrameReference(frame), subframe, this.attributes.GetAttributeReference(attribute), this.relations.GetRelationReference(relation), this.frames.GetFrameReference(frame2), subframe2, this.attributes.GetAttributeReference(attribute2));
    }

    void AddOARVChunk(String frame, String subframe, String attribute, String relation, String[] value, String multiplicity, String[] Cf) throws Exception {
        Attribute a = null;
        if (attribute != null) {
            a = this.attributes.GetAttributeReference(attribute);
        }
        if (value != null && a != null) {
            for (int i = 0; i < value.length; ++i) {
                a.IsValidValue(value[i]);
            }
        }
        this.chunks.AddOARVChunk(this.frames.GetFrameReference(frame), subframe, this.attributes.GetAttributeReference(attribute), this.relations.GetRelationReference(relation), value, multiplicity, Cf);
    }

    void AddOARVChunk(String name, String frame, String subframe, String attribute, String relation, String[] value, String multiplicity, String[] Cf) throws Exception {
        Attribute a = null;
        if (attribute != null) {
            a = this.attributes.GetAttributeReference(attribute);
        }
        if (value != null && a != null) {
            for (int i = 0; i < value.length; ++i) {
                a.IsValidValue(value[i]);
            }
        }
        this.chunks.AddOARVChunk(name, this.frames.GetFrameReference(frame), subframe, this.attributes.GetAttributeReference(attribute), this.relations.GetRelationReference(relation), value, multiplicity, Cf);
    }

    String[][][][][] GetAllFrames2() throws Exception {
        return this.frames.GetAllFrames2();
    }

    void AddParentFrame(String frame, String parentframe) throws Exception {
        this.frames.AddParentFrame(frame, parentframe);
    }

    void AddRule(String rule) throws Exception {
        this.rules.AddRule(rule);
    }

    String[] GetAllAttributes() throws Exception {
        return this.attributes.GetAllAttributes();
    }

    void AddSlot(String frame, String attribute, String[] question, String description) throws Exception {
        this.frames.AddSlot(frame, this.attributes.GetAttributeReference(attribute), question, description);
    }

    void AddSubframe(String frame, String subframe, String baseframe, String multiplicity) throws Exception {
        this.frames.AddSubframe(frame, subframe, baseframe, multiplicity);
    }

    void AddThenClause(String rule, String chunk) throws Exception {
        this.rules.AddThenClause(rule, this.chunks.GetChunkReference(chunk));
    }

    FramE GetFrameReference(String frame) throws Exception {
        return this.frames.GetFrameReference(frame);
    }

    String[][][] GetAttribute(String attribute) throws Exception {
        return this.attributes.GetAttribute(attribute);
    }

    void DeleteAttribute(String attribute) throws Exception {
        this.attributes.DeleteAttribute(attribute);
        this.frames.DeleteSlotsWithAttribute(attribute);
        this.rules.DeleteClausesWithAttribute(attribute);
        this.chunks.DeleteChunksWithAttribute(attribute);
    }

    String GetChunk(String chunk) throws Exception {
        return this.chunks.GetChunk(chunk);
    }

    KnowledgeChunk GetChunkReference(String chunk) throws Exception {
        return this.chunks.GetChunkReference(chunk);
    }

    String[][] GetChunkAsStrings(String chunk) throws Exception {
        return this.chunks.GetChunkAsStrings(chunk);
    }

    void DeleteChunk(String chunk) throws Exception {
        this.chunks.DeleteChunk(chunk);
        this.rules.DeleteClausesWithChunk(chunk);
    }

    String[][] GetDomain(String domain) throws Exception {
        return this.domains.GetDomain(domain);
    }

    void DeleteDomain(String domain, boolean ind2) throws Exception {
        this.domains.DeleteDomain(domain);
        this.rules.DeleteClausesWithDomain(domain);
        this.chunks.DeleteChunksWithDomain(domain);
        if (!ind2) {
            this.attributes.FreeAttributeFromDomain(domain);
        } else {
            this.frames.DeleteSlotsWithDomain(domain);
            this.attributes.DeleteAttributesWithDomain(domain);
        }
    }

    String[][][][] GetFrame(String frame) throws Exception {
        return this.frames.GetFrame(frame);
    }

    LinkedList DeleteFrame(String frame) throws Exception {
        LinkedList pom1 = this.frames.DeleteFrame(frame);
        this.rules.DeleteClausesWithFrame(frame);
        this.chunks.DeleteChunksWithFrame(frame);
        for (String[][] pom : pom1) {
            int j;
            for (j = 0; j < pom[1].length; ++j) {
                this.rules.DeleteClausesWithFrameSlot(pom[0][0], pom[1][j]);
                this.chunks.DeleteChunksWithFrameSlot(pom[0][0], pom[1][j]);
            }
            for (j = 0; j < pom[2].length; ++j) {
                this.rules.DeleteClausesWithSubframe(pom[0][0], pom[2][j]);
                this.chunks.DeleteChunksWithSubframe(pom[0][0], pom[2][j]);
            }
        }
        return pom1;
    }

    String GetIfClause(String rule, String chunk) throws Exception {
        return this.rules.GetIfClause(rule, chunk);
    }

    void DeleteIfClause(String rule, String chunk) throws Exception {
        this.rules.DeleteIfClause(rule, chunk);
    }

    LinkedList DeleteParentFrame(String frame, String parentframe) throws Exception {
        LinkedList pom1 = this.frames.DeleteParentFrame(frame, parentframe);
        for (String[][] pom : pom1) {
            int j;
            for (j = 0; j < pom[1].length; ++j) {
                this.rules.DeleteClausesWithFrameSlot(pom[0][0], pom[1][j]);
                this.chunks.DeleteChunksWithFrameSlot(pom[0][0], pom[1][j]);
            }
            for (j = 0; j < pom[2].length; ++j) {
                this.rules.DeleteClausesWithSubframe(pom[0][0], pom[2][j]);
                this.chunks.DeleteChunksWithSubframe(pom[0][0], pom[2][j]);
            }
        }
        return pom1;
    }

    String[][] GetRule(String rule) throws Exception {
        return this.rules.GetRule(rule);
    }

    void DeleteRule(String rule) throws Exception {
        this.rules.DeleteRule(rule);
    }

    LinkedList DeleteSlot(String frame, String attribute) throws Exception {
        LinkedList pom1 = this.frames.DeleteSlot(frame, attribute);
        for (String[][] pom : pom1) {
            for (int j = 0; j < pom[1].length; ++j) {
                this.rules.DeleteClausesWithFrameSlot(pom[0][0], pom[1][j]);
                this.chunks.DeleteChunksWithFrameSlot(pom[0][0], pom[1][j]);
            }
        }
        return pom1;
    }

    String[] GetSubframe(String frame, String subframe) throws Exception {
        return this.frames.GetSubframe(frame, subframe);
    }

    void DeleteSubframe(String frame, String subframe) throws Exception {
        this.frames.DeleteSubframe(frame, subframe);
        this.rules.DeleteClausesWithSubframe(frame, subframe);
        this.chunks.DeleteChunksWithSubframe(frame, subframe);
    }

    String GetThenClause(String rule, String chunk) throws Exception {
        return this.rules.GetThenClause(rule, chunk);
    }

    void DeleteThenClause(String rule, String chunk) throws Exception {
        this.rules.DeleteThenClause(rule, chunk);
    }

    void EditAttribute(String attribute, String domain) throws Exception {
        this.attributes.EditAttribute(attribute, this.domains.GetDomainReference(domain));
        this.rules.DeleteClausesWithAttribute(attribute);
        this.chunks.DeleteChunksWithAttribute(attribute);
    }

    void EditDomain(String domain, String type, String[] restrictions) throws Exception {
        this.domains.EditDomain(domain, type, restrictions);
        this.rules.DeleteClausesWithDomain(domain);
        this.chunks.DeleteChunksWithDomain(domain);
    }

    void EditIfClause(String rule, String chunk, String oldchunk) throws Exception {
        this.rules.EditIfClause(rule, this.chunks.GetChunkReference(chunk), oldchunk);
    }

    void EditOAAcChunk(String chunk, String frame, String subframe, String attribute, String action) throws Exception {
        this.chunks.EditOAAcChunk(chunk, this.frames.GetFrameReference(frame), subframe, this.attributes.GetAttributeReference(attribute), this.actions.GetActionReference(action));
    }

    void EditOARFChunk(String chunk, String frame, String subframe, String attribute, String relation, String formula, String[][][] arguments) throws Exception {
        FramE frameref = this.frames.GetFrameReference(frame);
        Attribute attributeref = this.attributes.GetAttributeReference(attribute);
        Relation relationref = this.relations.GetRelationReference(relation);
        Formula formularef = this.formulas.GetFormulaReference(formula);
        Object[][] argumentsref = null;
        if (arguments != null) {
            int i;
            argumentsref = new Object[arguments.length][0];
            for (i = 0; i < argumentsref.length; ++i) {
                argumentsref[i] = null;
            }
            for (i = 0; i < arguments.length; ++i) {
                if (arguments[i] != null) {
                    if (arguments[i].length == 1 && arguments[i][0].length == 3) {
                        argumentsref[i] = new Object[3];
                        argumentsref[i][0] = this.frames.GetFrameReference(arguments[i][0][0]);
                        argumentsref[i][1] = arguments[i][0][1];
                        argumentsref[i][2] = this.attributes.GetAttributeReference(arguments[i][0][2]);
                        continue;
                    }
                    argumentsref[i] = new Object[1];
                    argumentsref[i][0] = arguments[i];
                    continue;
                }
                throw new Exception("You must enter arg" + (i + 1));
            }
        }
        String[][] s = null;
        if (attributeref != null) {
            s = attributeref.GetDomain();
        }
        String s2 = null;
        if (s != null) {
            s2 = s[1][0];
        }
        formularef.CheckArguments(s2, argumentsref);
        this.chunks.EditOARFChunk(chunk, frameref, subframe, attributeref, relationref, formularef, argumentsref);
    }

    void EditOAROAChunk(String chunk, String frame, String subframe, String attribute, String relation, String frame2, String subframe2, String attribute2) throws Exception {
        this.chunks.EditOAROAChunk(chunk, this.frames.GetFrameReference(frame), subframe, this.attributes.GetAttributeReference(attribute), this.relations.GetRelationReference(relation), this.frames.GetFrameReference(frame2), subframe2, this.attributes.GetAttributeReference(attribute2));
    }

    void EditOARVChunk(String chunk, String frame, String subframe, String attribute, String relation, String[] value, String multiplicity, String[] Cf) throws Exception {
        Attribute a = null;
        if (attribute != null) {
            a = this.attributes.GetAttributeReference(attribute);
        }
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                a.IsValidValue(value[i]);
            }
        }
        this.chunks.EditOARVChunk(chunk, this.frames.GetFrameReference(frame), subframe, this.attributes.GetAttributeReference(attribute), this.relations.GetRelationReference(relation), value, multiplicity, Cf);
    }

    void EditRuleType(String rule, String ind, String importance) throws Exception {
        this.rules.EditRuleType(rule, ind, importance);
    }

    LinkedList EditSlot(String frame, String attribute, String[] question, String description, String oldattribute) throws Exception {
        LinkedList pom1 = this.frames.EditSlot(frame, this.attributes.GetAttributeReference(attribute), question, description, oldattribute);
        for (String[][] pom : pom1) {
            for (int j = 0; j < pom[1].length; ++j) {
                this.rules.DeleteClausesWithFrameSlot(pom[0][0], pom[1][j]);
                this.chunks.DeleteChunksWithFrameSlot(pom[0][0], pom[1][j]);
            }
        }
        return pom1;
    }

    void EditThenClause(String rule, String chunk, String oldchunk) throws Exception {
        this.rules.EditThenClause(rule, this.chunks.GetChunkReference(chunk), oldchunk);
    }

    String[][] GetSlot(String frame, String attribute) throws Exception {
        return this.frames.GetSlot(frame, attribute);
    }

    String[][][][] GetParentFrame(String frame, String parentframe) throws Exception {
        return this.frames.GetParentFrame(frame, parentframe);
    }

    String[][][] GetAllRules() throws Exception {
        return this.rules.GetAllRules();
    }

    String[][][][][] GetAllRules2() throws Exception {
        return this.rules.GetAllRules2();
    }

    String[][][][] GetAllAttributes2() throws Exception {
        return this.attributes.GetAllAttributes2();
    }

    void AddMedia(String name, String path, String frame, String attribute, boolean ucitavanje) throws Exception {
        this.frames.AddMedia(name, path, frame, attribute, ucitavanje);
    }

    String[] GetMedia(String frame, String attribute, String media) throws Exception {
        return this.frames.GetMedia(frame, attribute, media);
    }

    void DeleteMedia(String frame, String attribute, String media) throws Exception {
        this.frames.DeleteMedia(frame, attribute, media);
    }
}

