/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Action;
import don.Attribute;
import don.Domain;
import don.Formula;
import don.FramE;
import don.KnowledgeChunk;
import don.KnowledgeElementsException;
import don.OAAc;
import don.OARF;
import don.OAROA;
import don.OARV;
import don.Relation;
import don.Rule;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

class KnowledgeElements
implements Serializable {
    protected LinkedList elements = new LinkedList();

    KnowledgeElements() {
    }

    String[][][] GetAllDomains() throws Exception {
        Iterator i = this.elements.iterator();
        String[][][] pom = new String[this.elements.size()][0][0];
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Domain)) {
                throw new KnowledgeElementsException(1, null);
            }
            Domain d = (Domain)o;
            pom[j] = d.GetDomain();
            ++j;
        }
        return pom;
    }

    Domain GetDomainReference(String domain) throws Exception {
        if (domain == null) {
            throw new KnowledgeElementsException(2, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof Domain)) {
                throw new KnowledgeElementsException(1, null);
            }
            Domain d = (Domain)o;
            if (!d.GetName().equals(domain.trim())) continue;
            return d;
        }
        throw new KnowledgeElementsException(3, domain.trim());
    }

    void AddAttribute(String name, Domain domainref) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof Attribute)) {
                throw new KnowledgeElementsException(4, null);
            }
            Attribute a = (Attribute)o;
            if (!a.GetName().equals(name.trim())) continue;
            throw new KnowledgeElementsException(5, name.trim());
        }
        Attribute pom = new Attribute(name, domainref);
        this.elements.addLast(pom);
    }

    String[][][][][][][] GetAllFrames() throws Exception {
        Iterator i = this.elements.iterator();
        String[][][][][][][] pom = new String[this.elements.size()][0][0][0][0][0][0];
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            pom[j] = f.GetFrame();
            ++j;
        }
        if (this.elements.size() == 0) {
            return null;
        }
        return pom;
    }

    String[][] GetAllRelations() throws Exception {
        Iterator i = this.elements.iterator();
        String[][] pom = new String[this.elements.size()][0];
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Relation)) {
                throw new KnowledgeElementsException(7, null);
            }
            Relation r = (Relation)o;
            pom[j] = new String[2];
            pom[j][0] = r.GetName();
            pom[j][1] = r.GetDescription();
            ++j;
        }
        return pom;
    }

    String[][] GetAllFormulas() throws Exception {
        Iterator i = this.elements.iterator();
        String[][] pom = new String[this.elements.size()][0];
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Formula)) {
                throw new KnowledgeElementsException(8, null);
            }
            Formula f = (Formula)o;
            pom[j] = new String[3];
            pom[j][0] = f.GetName();
            pom[j][1] = f.GetDescription();
            pom[j][2] = String.valueOf(f.GetArgumentCount());
            ++j;
        }
        return pom;
    }

    String[][] GetAllActions() throws Exception {
        Iterator i = this.elements.iterator();
        String[][] pom = new String[this.elements.size()][0];
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Action)) {
                throw new KnowledgeElementsException(9, null);
            }
            Action a = (Action)o;
            pom[j] = new String[2];
            pom[j][0] = a.GetName();
            pom[j][1] = a.GetDescription();
            ++j;
        }
        return pom;
    }

    void AddDomain(String name, String type, String[] restrictions) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof Domain)) {
                throw new KnowledgeElementsException(1, null);
            }
            Domain d = (Domain)o;
            if (!d.GetName().equals(name.trim())) continue;
            throw new KnowledgeElementsException(10, name.trim());
        }
        Domain pom = new Domain(name, type, restrictions);
        this.elements.addLast(pom);
    }

    void AddFrame(String name) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (!f.GetName().equals(name.trim())) continue;
            throw new KnowledgeElementsException(11, name.trim());
        }
        FramE pom = new FramE(name);
        this.elements.addLast(pom);
    }

    KnowledgeChunk GetChunkReference(String chunk) throws Exception {
        if (chunk == null) {
            throw new KnowledgeElementsException(12, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof KnowledgeChunk)) {
                throw new KnowledgeElementsException(13, null);
            }
            KnowledgeChunk c = (KnowledgeChunk)o;
            if (!c.GetName().equals(chunk)) continue;
            return c;
        }
        throw new KnowledgeElementsException(14, chunk);
    }

    String[][] GetChunkAsStrings(String chunk) throws Exception {
        if (chunk == null) {
            throw new KnowledgeElementsException(12, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof KnowledgeChunk)) {
                throw new KnowledgeElementsException(13, null);
            }
            KnowledgeChunk c = (KnowledgeChunk)o;
            if (!c.GetName().equals(chunk)) continue;
            return c.GetChunkAsStrings();
        }
        throw new KnowledgeElementsException(14, chunk);
    }

    void AddIfClause(String rule, KnowledgeChunk chunkref) throws Exception {
        if (rule == null) {
            throw new KnowledgeElementsException(15, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            r.AddIfClause(chunkref);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(17, rule);
        }
    }

    FramE GetFrameReference(String frame) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(18, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            return f;
        }
        throw new KnowledgeElementsException(19, frame.trim());
    }

    Attribute GetAttributeReference(String attribute) throws Exception {
        if (attribute == null) {
            throw new KnowledgeElementsException(20, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof Attribute)) {
                throw new KnowledgeElementsException(21, null);
            }
            Attribute a = (Attribute)o;
            if (!a.GetName().equals(attribute.trim())) continue;
            return a;
        }
        throw new KnowledgeElementsException(22, attribute.trim());
    }

    Action GetActionReference(String action) throws Exception {
        if (action == null) {
            throw new KnowledgeElementsException(23, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof Action)) {
                throw new KnowledgeElementsException(9, null);
            }
            Action a = (Action)o;
            if (!a.GetName().equals(action.trim())) continue;
            return a;
        }
        throw new KnowledgeElementsException(24, action.trim());
    }

    void AddOAAcChunk(FramE frameref, String subframe, Attribute attributeref, Action actionref) throws Exception {
        for (Object o : this.elements) {
            if (o instanceof KnowledgeChunk) continue;
            throw new KnowledgeElementsException(13, null);
        }
        OAAc pom = new OAAc(frameref, subframe, attributeref, actionref);
        this.elements.addLast(pom);
    }

    void AddOAAcChunk(String name, FramE frameref, String subframe, Attribute attributeref, Action actionref) throws Exception {
        for (Object o : this.elements) {
            if (o instanceof KnowledgeChunk) continue;
            throw new KnowledgeElementsException(13, null);
        }
        OAAc pom = new OAAc(name, frameref, subframe, attributeref, actionref);
        this.elements.addLast(pom);
    }

    Formula GetFormulaReference(String formula) throws Exception {
        if (formula == null) {
            throw new KnowledgeElementsException(25, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof Formula)) {
                throw new KnowledgeElementsException(8, null);
            }
            Formula f = (Formula)o;
            if (!f.GetName().equals(formula.trim())) continue;
            return f;
        }
        throw new KnowledgeElementsException(26, formula.trim());
    }

    Relation GetRelationReference(String relation) throws Exception {
        if (relation == null) {
            throw new KnowledgeElementsException(27, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof Relation)) {
                throw new KnowledgeElementsException(28, null);
            }
            Relation r = (Relation)o;
            if (!r.GetName().equals(relation.trim())) continue;
            return r;
        }
        throw new KnowledgeElementsException(29, relation.trim());
    }

    void AddOARFChunk(FramE frameref, String subframe, Attribute attributeref, Relation relationref, Formula formularef, Object[][] argumentsref) throws Exception {
        for (Object o : this.elements) {
            if (o instanceof KnowledgeChunk) continue;
            throw new KnowledgeElementsException(13, null);
        }
        OARF pom = new OARF(frameref, subframe, attributeref, relationref, formularef, argumentsref);
        this.elements.addLast(pom);
    }

    void AddOARFChunk(String name, FramE frameref, String subframe, Attribute attributeref, Relation relationref, Formula formularef, Object[][] argumentsref) throws Exception {
        for (Object o : this.elements) {
            if (o instanceof KnowledgeChunk) continue;
            throw new KnowledgeElementsException(13, null);
        }
        OARF pom = new OARF(name, frameref, subframe, attributeref, relationref, formularef, argumentsref);
        this.elements.addLast(pom);
    }

    void AddOAROAChunk(FramE frameref, String subframe, Attribute attributeref, Relation relationref, FramE frameref2, String subframe2, Attribute attributeref2) throws Exception {
        for (Object o : this.elements) {
            if (o instanceof KnowledgeChunk) continue;
            throw new KnowledgeElementsException(13, null);
        }
        OAROA pom = new OAROA(frameref, subframe, attributeref, relationref, frameref2, subframe2, attributeref2);
        this.elements.addLast(pom);
    }

    void AddOAROAChunk(String name, FramE frameref, String subframe, Attribute attributeref, Relation relationref, FramE frameref2, String subframe2, Attribute attributeref2) throws Exception {
        for (Object o : this.elements) {
            if (o instanceof KnowledgeChunk) continue;
            throw new KnowledgeElementsException(13, null);
        }
        OAROA pom = new OAROA(name, frameref, subframe, attributeref, relationref, frameref2, subframe2, attributeref2);
        this.elements.addLast(pom);
    }

    void AddOARVChunk(FramE frameref, String subframe, Attribute attributeref, Relation relationref, String[] value, String multiplicity, String[] Cf) throws Exception {
        for (Object o : this.elements) {
            if (o instanceof KnowledgeChunk) continue;
            throw new KnowledgeElementsException(13, null);
        }
        OARV pom = new OARV(frameref, subframe, attributeref, relationref, value, multiplicity, Cf);
        this.elements.addLast(pom);
    }

    void AddOARVChunk(String name, FramE frameref, String subframe, Attribute attributeref, Relation relationref, String[] value, String multiplicity, String[] Cf) throws Exception {
        for (Object o : this.elements) {
            if (o instanceof KnowledgeChunk) continue;
            throw new KnowledgeElementsException(13, null);
        }
        OARV pom = new OARV(name, frameref, subframe, attributeref, relationref, value, multiplicity, Cf);
        this.elements.addLast(pom);
    }

    String[][][][][] GetAllFrames2() throws Exception {
        Iterator i = this.elements.iterator();
        String[][][][][] pom = new String[this.elements.size()][0][0][0][0];
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            pom[j] = f.GetFrame2();
            ++j;
        }
        return pom;
    }

    void AddParentFrame(String frame, String parentframe) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(30, null);
        }
        if (parentframe == null) {
            throw new KnowledgeElementsException(31, null);
        }
        Iterator i = this.elements.iterator();
        FramE pom1 = null;
        FramE pom2 = null;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (f.GetName().equals(parentframe.trim())) {
                pom1 = f;
            }
            if (!f.GetName().equals(frame.trim())) continue;
            pom2 = f;
        }
        if (pom1 == null) {
            throw new KnowledgeElementsException(33, parentframe.trim());
        }
        if (pom2 == null) {
            throw new KnowledgeElementsException(32, frame.trim());
        }
        pom2.AddParentFrame(pom1);
    }

    void AddRule(String rule) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            throw new KnowledgeElementsException(34, rule.trim());
        }
        Rule pom = new Rule(rule);
        this.elements.addLast(pom);
    }

    String[] GetAllAttributes() throws Exception {
        Iterator i = this.elements.iterator();
        String[] pom = new String[this.elements.size()];
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Attribute)) {
                throw new KnowledgeElementsException(21, null);
            }
            Attribute a = (Attribute)o;
            pom[j] = a.GetName();
            ++j;
        }
        return pom;
    }

    void AddSlot(String frame, Attribute attributeref, String[] question, String description) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(35, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            f.AddSlot(attributeref, question, description);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(36, frame.trim());
        }
    }

    void AddSubframe(String frame, String subframe, String baseframe, String multiplicity) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(37, null);
        }
        if (baseframe == null) {
            throw new KnowledgeElementsException(38, null);
        }
        Iterator i = this.elements.iterator();
        FramE pom1 = null;
        FramE pom2 = null;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (f.GetName().equals(baseframe.trim())) {
                pom1 = f;
            }
            if (!f.GetName().equals(frame.trim())) continue;
            pom2 = f;
        }
        if (pom1 == null) {
            throw new KnowledgeElementsException(40, baseframe.trim());
        }
        if (pom2 == null) {
            throw new KnowledgeElementsException(39, frame.trim());
        }
        pom2.AddSubframe(subframe, pom1, multiplicity);
    }

    String[] GetAllChunks() throws Exception {
        Iterator i = this.elements.iterator();
        String[] pom = new String[this.elements.size()];
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof KnowledgeChunk)) {
                throw new KnowledgeElementsException(13, null);
            }
            KnowledgeChunk c = (KnowledgeChunk)o;
            pom[j] = c.GetChunkAsString();
            ++j;
        }
        return pom;
    }

    String[][][] GetAllChunks2() throws Exception {
        Iterator i = this.elements.iterator();
        String[][][] pom = new String[this.elements.size()][0][0];
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof KnowledgeChunk)) {
                throw new KnowledgeElementsException(13, null);
            }
            KnowledgeChunk c = (KnowledgeChunk)o;
            pom[j] = c.GetChunkAsStrings();
            ++j;
        }
        return pom;
    }

    void AddThenClause(String rule, KnowledgeChunk chunkref) throws Exception {
        if (rule == null) {
            throw new KnowledgeElementsException(41, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            r.AddThenClause(chunkref);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(42, rule);
        }
    }

    String[][][] GetAttribute(String attribute) throws Exception {
        if (attribute == null) {
            throw new KnowledgeElementsException(43, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof Attribute)) {
                throw new KnowledgeElementsException(21, null);
            }
            Attribute a = (Attribute)o;
            if (!a.GetName().equals(attribute.trim())) continue;
            return a.GetAttribute();
        }
        throw new KnowledgeElementsException(44, attribute.trim());
    }

    void DeleteSlotsWithAttribute(String attribute) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            f.DeleteSlotWithAttribute(attribute);
        }
    }

    void DeleteClausesWithAttribute(String attribute) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            r.DeleteClausesWithAttribute(attribute);
        }
    }

    void DeleteChunksWithAttribute(String attribute) throws Exception {
        if (attribute != null) {
            Iterator i = this.elements.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof KnowledgeChunk)) {
                    throw new KnowledgeElementsException(13, null);
                }
                KnowledgeChunk c = (KnowledgeChunk)o;
                String[] pom = c.GetAttributeName();
                boolean ind = false;
                for (int j = 0; j < pom.length; ++j) {
                    if (!pom[j].equals(attribute.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
        }
    }

    void DeleteAttribute(String attribute) throws Exception {
        if (attribute == null) {
            throw new KnowledgeElementsException(45, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof Attribute)) {
                throw new KnowledgeElementsException(21, null);
            }
            Attribute a = (Attribute)o;
            if (!a.GetName().equals(attribute.trim())) continue;
            i.remove();
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(46, attribute.trim());
        }
    }

    String GetChunk(String chunk) throws Exception {
        if (chunk == null) {
            throw new KnowledgeElementsException(47, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof KnowledgeChunk)) {
                throw new KnowledgeElementsException(13, null);
            }
            KnowledgeChunk c = (KnowledgeChunk)o;
            if (!c.GetName().equals(chunk)) continue;
            return c.GetChunkAsString();
        }
        throw new KnowledgeElementsException(48, chunk);
    }

    void DeleteClausesWithChunk(String chunk) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            r.DeleteClausesWithChunk(chunk);
        }
    }

    void DeleteChunk(String chunk) throws Exception {
        if (chunk == null) {
            throw new KnowledgeElementsException(49, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof KnowledgeChunk)) {
                throw new KnowledgeElementsException(13, null);
            }
            KnowledgeChunk c = (KnowledgeChunk)o;
            if (!c.GetName().equals(chunk)) continue;
            i.remove();
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(50, chunk);
        }
    }

    String[][] GetDomain(String domain) throws Exception {
        if (domain == null) {
            throw new KnowledgeElementsException(51, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof Domain)) {
                throw new KnowledgeElementsException(1, null);
            }
            Domain d = (Domain)o;
            if (!d.GetName().equals(domain.trim())) continue;
            return d.GetDomain();
        }
        throw new KnowledgeElementsException(52, domain.trim());
    }

    void DeleteClausesWithDomain(String domain) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            r.DeleteClausesWithDomain(domain);
        }
    }

    void DeleteChunksWithDomain(String domain) throws Exception {
        if (domain != null) {
            Iterator i = this.elements.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof KnowledgeChunk)) {
                    throw new KnowledgeElementsException(13, null);
                }
                KnowledgeChunk c = (KnowledgeChunk)o;
                String[] pom = c.GetAttributeDomain();
                boolean ind = false;
                for (int j = 0; j < pom.length; ++j) {
                    if (!pom[j].equals(domain.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
        }
    }

    void DeleteSlotsWithDomain(String domain) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            f.DeleteSlotsWithDomain(domain);
        }
    }

    void DeleteAttributesWithDomain(String domain) throws Exception {
        if (domain != null) {
            Iterator i = this.elements.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof Attribute)) {
                    throw new KnowledgeElementsException(21, null);
                }
                Attribute a = (Attribute)o;
                if (a.GetDomainName() == null || !a.GetDomainName().equals(domain.trim())) continue;
                i.remove();
            }
        }
    }

    void FreeAttributeFromDomain(String domain) throws Exception {
        if (domain != null) {
            for (Object o : this.elements) {
                if (!(o instanceof Attribute)) {
                    throw new KnowledgeElementsException(21, null);
                }
                Attribute a = (Attribute)o;
                if (a.GetDomainName() == null || !a.GetDomainName().equals(domain.trim())) continue;
                a.SetDomain(null);
            }
        }
    }

    void DeleteDomain(String domain) throws Exception {
        if (domain == null) {
            throw new KnowledgeElementsException(53, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof Domain)) {
                throw new KnowledgeElementsException(1, null);
            }
            Domain d = (Domain)o;
            if (!d.GetName().equals(domain.trim())) continue;
            i.remove();
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(54, domain.trim());
        }
    }

    String[][][][] GetFrame(String frame) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(55, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            return f.GetFrame2();
        }
        throw new KnowledgeElementsException(56, frame.trim());
    }

    void DeleteClausesWithFrame(String frame) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            r.DeleteClausesWithFrame(frame);
        }
    }

    void DeleteChunksWithFrame(String frame) throws Exception {
        if (frame != null) {
            Iterator i = this.elements.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof KnowledgeChunk)) {
                    throw new KnowledgeElementsException(13, null);
                }
                KnowledgeChunk c = (KnowledgeChunk)o;
                String[] pom1 = c.GetFrameName();
                String[] pom2 = c.GetSubframeBaseframe();
                boolean ind = false;
                for (int j = 0; j < pom1.length; ++j) {
                    if (pom1[j].equals(frame.trim())) {
                        ind = true;
                    }
                    if (pom2[j] == null || !pom2[j].equals(frame.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
        }
    }

    LinkedList DeleteFrame(String frame) throws Exception {
        FramE f;
        FramE f2;
        if (frame == null) {
            throw new KnowledgeElementsException(57, null);
        }
        LinkedList<String[][][][]> pom1 = new LinkedList<String[][][][]>();
        LinkedList<String[][][][]> pom2 = new LinkedList<String[][][][]>();
        LinkedList<String[][]> pom3 = new LinkedList<String[][]>();
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            f2 = (FramE)o;
            if (f2.GetName().equals(frame.trim())) continue;
            pom1.addLast(f2.GetFrame2());
        }
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            f2 = (FramE)o;
            f2.DeleteSubframeWithFrame(frame.trim());
            f2.DeleteParentFrameWithFrame(frame.trim());
        }
        boolean ind = false;
        Iterator i = this.elements.iterator();
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            i.remove();
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(58, frame.trim());
        }
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            f = (FramE)o;
            pom2.addLast(f.GetFrame2());
        }
        Iterator j = pom2.iterator();
        for (String[][][][] por1 : pom1) {
            int l;
            boolean ind2;
            int k;
            int m;
            String[][][][] por2;
            if (por1[1].length <= (por2 = (String[][][][])j.next())[1].length && por1[2][0].length <= por2[2][0].length) continue;
            String[][] pom = new String[3][0];
            pom[0] = new String[1];
            pom[0][0] = por1[0][0][0][0];
            if (por1[1].length > por2[1].length) {
                pom[1] = new String[por1[1].length - por2[1].length];
                m = 0;
                for (k = 0; k < por1[1].length; ++k) {
                    ind2 = false;
                    for (l = 0; l < por2[1].length; ++l) {
                        if (!por1[1][k][1][0].equals(por2[1][l][1][0])) continue;
                        ind2 = true;
                    }
                    if (ind2) continue;
                    pom[1][m] = por1[1][k][1][0];
                    ++m;
                }
            }
            if (por1[2][0].length > por2[2][0].length) {
                // empty if block
            }
            pom[2] = new String[por1[2][0].length - por2[2][0].length];
            m = 0;
            for (k = 0; k < por1[2][0].length; ++k) {
                ind2 = false;
                for (l = 0; l < por2[2][0].length; ++l) {
                    if (!por1[2][0][k][0].equals(por2[2][0][l][0])) continue;
                    ind2 = true;
                }
                if (ind2) continue;
                pom[2][m] = por1[2][0][k][0];
                ++m;
            }
            pom3.addLast(pom);
        }
        return pom3;
    }

    String GetIfClause(String rule, String chunk) throws Exception {
        if (rule == null) {
            throw new KnowledgeElementsException(59, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            return r.GetIfClause(chunk);
        }
        throw new KnowledgeElementsException(60, rule.trim());
    }

    void DeleteIfClause(String rule, String chunk) throws Exception {
        if (rule == null) {
            throw new KnowledgeElementsException(61, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(4, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            r.DeleteIfClause(chunk);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(62, rule.trim());
        }
    }

    String[][][][] GetParentFrame(String frame, String parentframe) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(63, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            return f.GetParentFrame(parentframe);
        }
        throw new KnowledgeElementsException(64, frame.trim());
    }

    String[][] GetRule(String rule) throws Exception {
        if (rule == null) {
            throw new KnowledgeElementsException(65, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            return r.GetRule();
        }
        throw new KnowledgeElementsException(66, rule.trim());
    }

    void DeleteRule(String rule) throws Exception {
        if (rule == null) {
            throw new KnowledgeElementsException(67, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            i.remove();
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(68, rule.trim());
        }
    }

    String[][] GetSlot(String frame, String attribute) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(69, attribute);
        }
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            return f.GetSlot(attribute);
        }
        throw new KnowledgeElementsException(70, frame.trim());
    }

    void DeleteClausesWithFrameSlot(String frame, String attribute) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            r.DeleteClausesWithFrameSlot(frame, attribute);
        }
    }

    void DeleteChunksWithFrameSlot(String frame, String attribute) throws Exception {
        if (frame != null && attribute != null) {
            Iterator i = this.elements.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof KnowledgeChunk)) {
                    throw new KnowledgeElementsException(13, null);
                }
                KnowledgeChunk c = (KnowledgeChunk)o;
                String[] pom1 = c.GetFrameName();
                String[] pom2 = c.GetSubframeBaseframe();
                String[] pom3 = c.GetAttributeName();
                boolean ind = false;
                for (int j = 0; j < pom1.length; ++j) {
                    if (pom1[j].equals(frame.trim()) && pom3[j].equals(attribute)) {
                        ind = true;
                    }
                    if (pom2[j] == null || !pom2[j].equals(frame.trim()) || !pom3[j].equals(attribute.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
        }
    }

    LinkedList DeleteSlot(String frame, String attribute) throws Exception {
        FramE f;
        if (frame == null) {
            throw new KnowledgeElementsException(71, null);
        }
        LinkedList<String[][][][]> pom1 = new LinkedList<String[][][][]>();
        LinkedList<String[][][][]> pom2 = new LinkedList<String[][][][]>();
        LinkedList<String[][]> pom3 = new LinkedList<String[][]>();
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f2 = (FramE)o;
            pom1.addLast(f2.GetFrame2());
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            f.DeleteSlot(attribute);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(72, frame.trim());
        }
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            f = (FramE)o;
            pom2.addLast(f.GetFrame2());
        }
        Iterator j = pom2.iterator();
        for (String[][][][] por1 : pom1) {
            String[][][][] por2;
            if (por1[1].length <= (por2 = (String[][][][])j.next())[1].length) continue;
            String[][] pom = new String[2][0];
            pom[0] = new String[1];
            pom[0][0] = por1[0][0][0][0];
            if (por1[1].length > por2[1].length) {
                pom[1] = new String[por1[1].length - por2[1].length];
                int m = 0;
                for (int k = 0; k < por1[1].length; ++k) {
                    boolean ind2 = false;
                    for (int l = 0; l < por2[1].length; ++l) {
                        if (!por1[1][k][1][0].equals(por2[1][l][1][0])) continue;
                        ind2 = true;
                    }
                    if (ind2) continue;
                    pom[1][m] = por1[1][k][1][0];
                    ++m;
                }
            }
            pom3.addLast(pom);
        }
        return pom3;
    }

    String[] GetSubframe(String frame, String subframe) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(73, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            return f.GetSubframe(subframe);
        }
        throw new KnowledgeElementsException(74, frame.trim());
    }

    void DeleteClausesWithSubframe(String frame, String subframe) throws Exception {
        for (Object o : this.elements) {
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            r.DeleteClausesWithSubframe(frame, subframe);
        }
    }

    void DeleteChunksWithSubframe(String frame, String subframe) throws Exception {
        if (frame != null && subframe != null) {
            Iterator i = this.elements.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof KnowledgeChunk)) {
                    throw new KnowledgeElementsException(13, null);
                }
                KnowledgeChunk c = (KnowledgeChunk)o;
                String[][] pom = new String[2][0];
                pom[1] = c.GetSubframeName();
                boolean ind = false;
                for (int j = 0; j < pom[1].length; ++j) {
                    if (pom[1][j] == null || !pom[1][j].equals(subframe.trim()) && !pom[1][j].startsWith(subframe.trim() + "[") && !pom[1][j].startsWith(subframe.trim() + ".") && pom[1][j].indexOf("." + subframe.trim() + "[") <= -1 && !pom[1][j].endsWith("." + subframe.trim()) && pom[1][j].indexOf("." + subframe.trim() + ".") <= -1) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
        }
    }

    void DeleteSubframe(String frame, String subframe) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(75, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            f.DeleteSubframe(subframe);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(76, frame.trim());
        }
    }

    String GetThenClause(String rule, String chunk) throws Exception {
        if (rule == null) {
            throw new KnowledgeElementsException(77, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            return r.GetThenClause(chunk);
        }
        throw new KnowledgeElementsException(78, rule.trim());
    }

    void DeleteThenClause(String rule, String chunk) throws Exception {
        if (rule == null) {
            throw new KnowledgeElementsException(79, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            r.DeleteThenClause(chunk);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(80, rule);
        }
    }

    void EditAttribute(String name, Domain domainref) throws Exception {
        if (name == null) {
            throw new KnowledgeElementsException(81, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof Attribute)) {
                throw new KnowledgeElementsException(21, null);
            }
            Attribute a = (Attribute)o;
            if (!a.GetName().equals(name.trim())) continue;
            a.SetDomain(domainref);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(82, name.trim());
        }
    }

    void EditDomain(String name, String type, String[] restrictions) throws Exception {
        if (name == null) {
            throw new KnowledgeElementsException(83, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Domain)) {
                throw new KnowledgeElementsException(1, null);
            }
            Domain d = (Domain)o;
            if (!d.GetName().equals(name.trim())) continue;
            d.SetType(type);
            d.SetRestrictions(restrictions);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(84, name.trim());
        }
    }

    void EditIfClause(String rule, KnowledgeChunk chunkref, String oldchunk) throws Exception {
        if (rule == null) {
            throw new KnowledgeElementsException(85, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            r.EditIfClause(oldchunk, chunkref);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(86, rule);
        }
    }

    void EditOAAcChunk(String chunk, FramE frameref, String subframe, Attribute attributeref, Action actionref) throws Exception {
        if (chunk == null) {
            throw new KnowledgeElementsException(87, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof KnowledgeChunk)) {
                throw new KnowledgeElementsException(13, null);
            }
            KnowledgeChunk c = (KnowledgeChunk)o;
            if (!c.GetName().equals(chunk)) continue;
            if (c instanceof OAAc) {
                OAAc c2 = (OAAc)c;
                c2.SetFrame(frameref);
                c2.SetSubframe(subframe);
                c2.SetAttribute(attributeref);
                c2.SetAction(actionref);
                ind = true;
                continue;
            }
            throw new KnowledgeElementsException(88, chunk);
        }
        if (!ind) {
            throw new KnowledgeElementsException(89, chunk);
        }
    }

    void EditOARFChunk(String chunk, FramE frameref, String subframe, Attribute attributeref, Relation relationref, Formula formularef, Object[][] argumentsref) throws Exception {
        if (chunk == null) {
            throw new KnowledgeElementsException(90, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof KnowledgeChunk)) {
                throw new KnowledgeElementsException(13, null);
            }
            KnowledgeChunk c = (KnowledgeChunk)o;
            if (!c.GetName().equals(chunk)) continue;
            if (c instanceof OARF) {
                OARF c2 = (OARF)c;
                c2.SetFrame(frameref);
                c2.SetSubframe(subframe);
                c2.SetAttribute(attributeref);
                c2.SetRelation(relationref);
                c2.SetFormula(formularef);
                c2.SetArguments(argumentsref);
                ind = true;
                continue;
            }
            throw new KnowledgeElementsException(91, chunk);
        }
        if (!ind) {
            throw new KnowledgeElementsException(92, chunk);
        }
    }

    void EditOAROAChunk(String chunk, FramE frameref, String subframe, Attribute attributeref, Relation relationref, FramE frameref2, String subframe2, Attribute attributeref2) throws Exception {
        if (chunk == null) {
            throw new KnowledgeElementsException(93, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof KnowledgeChunk)) {
                throw new KnowledgeElementsException(13, null);
            }
            KnowledgeChunk c = (KnowledgeChunk)o;
            if (!c.GetName().equals(chunk)) continue;
            if (c instanceof OAROA) {
                OAROA c2 = (OAROA)c;
                c2.SetFrame(frameref);
                c2.SetSubframe(subframe);
                c2.SetAttribute(attributeref);
                c2.SetRelation(relationref);
                c2.SetFrame2(frameref2);
                c2.SetSubframe2(subframe2);
                c2.SetAttribute2(attributeref2);
                ind = true;
                continue;
            }
            throw new KnowledgeElementsException(94, chunk);
        }
        if (!ind) {
            throw new KnowledgeElementsException(95, chunk);
        }
    }

    void EditOARVChunk(String chunk, FramE frameref, String subframe, Attribute attributeref, Relation relationref, String[] value, String multiplicity, String[] Cf) throws Exception {
        if (chunk == null) {
            throw new KnowledgeElementsException(96, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof KnowledgeChunk)) {
                throw new KnowledgeElementsException(13, null);
            }
            KnowledgeChunk c = (KnowledgeChunk)o;
            if (!c.GetName().equals(chunk)) continue;
            if (c instanceof OARV) {
                OARV c2 = (OARV)c;
                c2.SetFrame(frameref);
                c2.SetSubframe(subframe);
                c2.SetAttribute(attributeref);
                c2.SetRelation(relationref);
                c2.SetValue(value, multiplicity, Cf);
                ind = true;
                continue;
            }
            throw new KnowledgeElementsException(97, chunk);
        }
        if (!ind) {
            throw new KnowledgeElementsException(98, chunk);
        }
    }

    void EditRuleType(String rule, String ind, String importance) throws Exception {
        if (rule == null) {
            throw new KnowledgeElementsException(99, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind2 = false;
        while (i.hasNext() && !ind2) {
            Object o = i.next();
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            r.SetType(ind);
            r.SetImportance(importance);
            ind2 = true;
        }
        if (!ind2) {
            throw new KnowledgeElementsException(100, rule.trim());
        }
    }

    LinkedList EditSlot(String frame, Attribute attributeref, String[] question, String description, String oldattribute) throws Exception {
        FramE f;
        if (frame == null) {
            throw new KnowledgeElementsException(101, null);
        }
        LinkedList<String[][][][]> pom1 = new LinkedList<String[][][][]>();
        LinkedList<String[][][][]> pom2 = new LinkedList<String[][][][]>();
        LinkedList<String[][]> pom3 = new LinkedList<String[][]>();
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f2 = (FramE)o;
            pom1.addLast(f2.GetFrame2());
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            f.SetSlot(attributeref, question, description, oldattribute);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(102, frame.trim());
        }
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            f = (FramE)o;
            pom2.addLast(f.GetFrame2());
        }
        Iterator j = pom2.iterator();
        for (String[][][][] por1 : pom1) {
            String[][][][] por2 = (String[][][][])j.next();
            String[][] pom = new String[2][0];
            pom[0] = new String[1];
            pom[0][0] = por1[0][0][0][0];
            boolean ind2 = false;
            for (int k = 0; k < por1[1].length; ++k) {
                if (por1[1][k][1][0].equals(por2[1][k][1][0])) continue;
                pom[1] = new String[1];
                pom[1][0] = por1[1][k][1][0];
            }
            pom3.addLast(pom);
        }
        return pom3;
    }

    void EditThenClause(String rule, KnowledgeChunk chunkref, String oldchunk) throws Exception {
        if (rule == null) {
            throw new KnowledgeElementsException(103, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            if (!r.GetName().equals(rule.trim())) continue;
            r.EditThenClause(oldchunk, chunkref);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(104, rule.trim());
        }
    }

    LinkedList DeleteParentFrame(String frame, String parentframe) throws Exception {
        FramE f;
        if (frame == null) {
            throw new KnowledgeElementsException(105, null);
        }
        LinkedList<String[][][][]> pom1 = new LinkedList<String[][][][]>();
        LinkedList<String[][][][]> pom2 = new LinkedList<String[][][][]>();
        LinkedList<String[][]> pom3 = new LinkedList<String[][]>();
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f2 = (FramE)o;
            pom1.addLast(f2.GetFrame2());
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            f.DeleteParentFrame(parentframe);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(106, frame.trim());
        }
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            f = (FramE)o;
            pom2.addLast(f.GetFrame2());
        }
        Iterator j = pom2.iterator();
        for (String[][][][] por1 : pom1) {
            int l;
            boolean ind2;
            int k;
            int m;
            String[][][][] por2;
            if (por1[1].length <= (por2 = (String[][][][])j.next())[1].length && por1[2][0].length <= por2[2][0].length) continue;
            String[][] pom = new String[3][0];
            pom[0] = new String[1];
            pom[0][0] = por1[0][0][0][0];
            if (por1[1].length > por2[1].length) {
                pom[1] = new String[por1[1].length - por2[1].length];
                m = 0;
                for (k = 0; k < por1[1].length; ++k) {
                    ind2 = false;
                    for (l = 0; l < por2[1].length; ++l) {
                        if (!por1[1][k][1][0].equals(por2[1][l][1][0])) continue;
                        ind2 = true;
                    }
                    if (ind2) continue;
                    pom[1][m] = por1[1][k][1][0];
                    ++m;
                }
            }
            if (por1[2][0].length > por2[2][0].length) {
                // empty if block
            }
            pom[2] = new String[por1[2][0].length - por2[2][0].length];
            m = 0;
            for (k = 0; k < por1[2][0].length; ++k) {
                ind2 = false;
                for (l = 0; l < por2[2][0].length; ++l) {
                    if (!por1[2][0][k][0].equals(por2[2][0][l][0])) continue;
                    ind2 = true;
                }
                if (ind2) continue;
                pom[2][m] = por1[2][0][k][0];
                ++m;
            }
            pom3.addLast(pom);
        }
        return pom3;
    }

    String[][][] GetAllRules() throws Exception {
        String[][][] pom = new String[this.elements.size()][0][0];
        Iterator i = this.elements.iterator();
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            pom[j] = r.GetRule();
            ++j;
        }
        return pom;
    }

    String[][][][][] GetAllRules2() throws Exception {
        String[][][][][] pom = new String[this.elements.size()][0][0][0][0];
        Iterator i = this.elements.iterator();
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Rule)) {
                throw new KnowledgeElementsException(16, null);
            }
            Rule r = (Rule)o;
            pom[j] = r.GetRule2();
            ++j;
        }
        return pom;
    }

    String[][][][] GetAllAttributes2() throws Exception {
        Iterator i = this.elements.iterator();
        String[][][][] pom = new String[this.elements.size()][0][0][0];
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Attribute)) {
                throw new KnowledgeElementsException(21, null);
            }
            Attribute a = (Attribute)o;
            pom[j] = a.GetAttribute();
            ++j;
        }
        return pom;
    }

    void AddMedia(String name, String path, String frame, String attribute, boolean ucitavanje) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(35, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            f.AddMedia(name, path, attribute, ucitavanje);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(36, frame.trim());
        }
    }

    String[] GetMedia(String frame, String attribute, String media) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(18, null);
        }
        for (Object o : this.elements) {
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            return f.GetMedia(attribute, media);
        }
        throw new KnowledgeElementsException(19, frame.trim());
    }

    void DeleteMedia(String frame, String attribute, String media) throws Exception {
        if (frame == null) {
            throw new KnowledgeElementsException(35, null);
        }
        Iterator i = this.elements.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Object o = i.next();
            if (!(o instanceof FramE)) {
                throw new KnowledgeElementsException(6, null);
            }
            FramE f = (FramE)o;
            if (!f.GetName().equals(frame.trim())) continue;
            f.DeleteMedia(attribute, media);
            ind = true;
        }
        if (!ind) {
            throw new KnowledgeElementsException(36, frame.trim());
        }
    }
}

