/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Attribute;
import don.Formula;
import don.FramE;
import don.KnowledgeChunk;
import don.OARFException;
import don.Relation;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

class OARF
extends KnowledgeChunk
implements Serializable {
    Object[][] arguments = null;
    Formula formula = null;

    OARF() {
    }

    OARF(FramE frameref, String subframe, Attribute attributeref, Relation relationref, Formula formularef, Object[][] arguments) throws Exception {
        if (frameref == null) {
            throw new OARFException(1, null);
        }
        if (attributeref == null) {
            throw new OARFException(3, null);
        }
        if (relationref == null) {
            throw new OARFException(4, null);
        }
        if (formularef == null) {
            throw new OARFException(5, null);
        }
        this.name = "OARF " + new Date().toString();
        this.frame = frameref;
        this.attribute = attributeref;
        this.subframe = subframe;
        this.relation = relationref;
        this.formula = formularef;
        this.arguments = arguments;
    }

    OARF(String name, FramE frameref, String subframe, Attribute attributeref, Relation relationref, Formula formularef, Object[][] arguments) throws Exception {
        if (frameref == null) {
            throw new OARFException(1, null);
        }
        if (attributeref == null) {
            throw new OARFException(3, null);
        }
        if (relationref == null) {
            throw new OARFException(4, null);
        }
        if (formularef == null) {
            throw new OARFException(5, null);
        }
        this.name = name;
        this.frame = frameref;
        this.attribute = attributeref;
        if (subframe != null) {
            this.subframe = subframe;
        }
        this.relation = relationref;
        this.formula = formularef;
        this.arguments = arguments;
    }

    void SetFrame(FramE frameref) throws Exception {
        if (frameref == null) {
            throw new OARFException(1, null);
        }
        this.frame = frameref;
    }

    void SetAttribute(Attribute attributeref) throws Exception {
        if (attributeref == null) {
            throw new OARFException(3, null);
        }
        this.attribute = attributeref;
    }

    void SetSubframe(String subframe) throws Exception {
        this.subframe = subframe;
    }

    void SetRelation(Relation relationref) throws Exception {
        if (relationref == null) {
            throw new OARFException(4, null);
        }
        this.relation = relationref;
    }

    void SetFormula(Formula formularef) throws Exception {
        if (formularef == null) {
            throw new OARFException(5, null);
        }
        this.formula = formularef;
    }

    void SetArguments(Object[][] arguments) {
        this.arguments = arguments;
    }

    Formula GetFormulaReference() {
        return this.formula;
    }

    String GetChunkAsString() {
        String pom = this.frame.GetName();
        if (this.subframe != null) {
            pom = pom + "." + this.subframe;
        }
        pom = pom + ":" + this.attribute.GetName() + " " + this.relation.GetName() + " " + this.formula.GetName() + " (";
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    pom = pom + ",";
                }
                if (this.arguments[i].length == 3) {
                    pom = pom + " " + ((FramE)this.arguments[i][0]).GetName();
                    if ((String)this.arguments[i][1] != null) {
                        pom = pom + "." + (String)this.arguments[i][1];
                    }
                    pom = pom + ":" + ((Attribute)this.arguments[i][2]).GetName() + " ";
                    continue;
                }
                String[][] pom2 = (String[][])this.arguments[i][0];
                String pom3 = " ";
                for (int j = 0; j < pom2.length; ++j) {
                    pom3 = pom3 + "(" + pom2[j][0] + ";" + pom2[j][1] + ")";
                }
                pom = pom + pom3 + " ";
            }
        }
        pom = pom + ")        (" + this.GetName() + ")";
        return pom;
    }

    String[][] GetChunkAsStrings() {
        String[][] pom = new String[this.arguments.length + 1][0];
        pom[0] = new String[7];
        pom[0][0] = "OARF";
        pom[0][1] = this.frame.GetName();
        pom[0][2] = this.subframe != null ? this.subframe : null;
        pom[0][3] = this.attribute.GetName();
        pom[0][4] = this.relation.GetName();
        pom[0][5] = this.formula.GetName();
        pom[0][6] = this.GetName();
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].length == 3) {
                    pom[i + 1] = new String[3];
                    pom[i + 1][0] = ((FramE)this.arguments[i][0]).GetName();
                    pom[i + 1][1] = (String)this.arguments[i][1];
                    pom[i + 1][2] = ((Attribute)this.arguments[i][2]).GetName();
                    continue;
                }
                String[][] pom2 = (String[][])this.arguments[i][0];
                pom[i + 1] = new String[pom2.length];
                for (int j = 0; j < pom2.length; ++j) {
                    pom[i + 1][j] = "(" + pom2[j][0] + ";" + pom2[j][1] + ")";
                }
            }
        }
        return pom;
    }

    String[] GetFrameName() {
        LinkedList<String> pom2 = new LinkedList<String>();
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].length != 3) continue;
                pom2.add(((FramE)this.arguments[i][0]).GetName());
            }
        }
        String[] pom = new String[pom2.size() + 1];
        pom[0] = this.frame.GetName();
        Iterator i = pom2.iterator();
        int j = 0;
        while (i.hasNext()) {
            pom[j + 1] = (String)i.next();
        }
        return pom;
    }

    String[] GetAttributeName() {
        LinkedList<String> pom2 = new LinkedList<String>();
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].length != 3) continue;
                pom2.add(((Attribute)this.arguments[i][2]).GetName());
            }
        }
        String[] pom = new String[pom2.size() + 1];
        pom[0] = this.attribute.GetName();
        Iterator i = pom2.iterator();
        int j = 0;
        while (i.hasNext()) {
            pom[j + 1] = (String)i.next();
        }
        return pom;
    }

    String[] GetSubframeName() {
        LinkedList<String> pom2 = new LinkedList<String>();
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].length != 3) continue;
                pom2.add((String)this.arguments[i][1]);
            }
        }
        String[] pom = new String[pom2.size() + 1];
        pom[0] = this.subframe;
        Iterator i = pom2.iterator();
        int j = 0;
        while (i.hasNext()) {
            pom[j + 1] = (String)i.next();
        }
        return pom;
    }

    String[] GetAttributeDomain() {
        LinkedList<String> pom2 = new LinkedList<String>();
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].length != 3) continue;
                pom2.add(((Attribute)this.arguments[i][2]).GetDomainName());
            }
        }
        String[] pom = new String[pom2.size() + 1];
        pom[0] = this.attribute.GetDomainName();
        Iterator i = pom2.iterator();
        int j = 0;
        while (i.hasNext()) {
            pom[j + 1] = (String)i.next();
        }
        return pom;
    }

    String[] GetSubframeBaseframe() {
        LinkedList<String> pom2 = new LinkedList<String>();
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].length != 3) continue;
                String s = (String)this.arguments[i][1];
                if (s != null) {
                    pom2.add(((FramE)this.arguments[i][0]).GetSubframeBaseframe(s));
                    continue;
                }
                pom2.add(s);
            }
        }
        String[] pom = new String[pom2.size() + 1];
        pom[0] = this.subframe != null ? this.frame.GetSubframeBaseframe(this.subframe) : null;
        Iterator i = pom2.iterator();
        int j = 0;
        while (i.hasNext()) {
            pom[j + 1] = (String)i.next();
        }
        return pom;
    }
}

