/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Clause;
import don.KnowledgeChunk;
import don.KnowledgeElement;
import don.RuleException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

class Rule
extends KnowledgeElement
implements Serializable {
    protected boolean OR = false;
    protected double importance = 0.0;
    LinkedList IF = new LinkedList();
    LinkedList THEN = new LinkedList();

    Rule() {
    }

    Rule(String rule) throws Exception {
        super(rule);
        if (rule == null) {
            throw new RuleException(1, null);
        }
        this.name = rule;
    }

    void AddIfClause(KnowledgeChunk chunkref) throws Exception {
        if (chunkref == null) {
            throw new RuleException(2, null);
        }
        for (Clause c : this.IF) {
            if (!c.GetChunkName().equals(chunkref.GetName())) continue;
            throw new RuleException(3, chunkref.GetChunkAsString());
        }
        Clause pom = new Clause(chunkref);
        this.IF.addLast(pom);
    }

    void AddThenClause(KnowledgeChunk chunkref) throws Exception {
        if (chunkref == null) {
            throw new RuleException(4, null);
        }
        for (Clause c : this.THEN) {
            if (!c.GetChunkName().equals(chunkref.GetName())) continue;
            throw new RuleException(5, chunkref.GetChunkAsString());
        }
        Clause pom = new Clause(chunkref);
        this.THEN.addLast(pom);
    }

    void DeleteClausesWithAttribute(String attribute) {
        if (attribute != null) {
            int j;
            boolean ind;
            String[] pom;
            Clause c;
            Iterator i = this.IF.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                pom = c.GetChunkAttribute();
                ind = false;
                for (j = 0; j < pom.length; ++j) {
                    if (!pom[j].equals(attribute.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
            i = this.THEN.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                pom = c.GetChunkAttribute();
                ind = false;
                for (j = 0; j < pom.length; ++j) {
                    if (!pom[j].equals(attribute.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
        }
    }

    void DeleteClausesWithChunk(String chunk) {
        if (chunk != null) {
            Clause c;
            Iterator i = this.IF.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                if (!c.GetChunkName().equals(chunk)) continue;
                i.remove();
            }
            i = this.THEN.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                if (!c.GetChunkName().equals(chunk)) continue;
                i.remove();
            }
        }
    }

    void DeleteClausesWithDomain(String domain) {
        if (domain != null) {
            int j;
            boolean ind;
            String[] pom;
            Clause c;
            Iterator i = this.IF.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                pom = c.GetChunkDomain();
                ind = false;
                for (j = 0; j < pom.length; ++j) {
                    if (!pom[j].equals(domain.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
            i = this.THEN.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                pom = c.GetChunkDomain();
                ind = false;
                for (j = 0; j < pom.length; ++j) {
                    if (!pom[j].equals(domain.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
        }
    }

    void DeleteClausesWithFrame(String frame) {
        if (frame != null) {
            int j;
            boolean ind;
            String[] pom;
            Clause c;
            Iterator i = this.IF.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                pom = c.GetChunkFrame();
                ind = false;
                for (j = 0; j < pom.length; ++j) {
                    if (!pom[j].equals(frame.trim())) continue;
                    ind = true;
                }
                pom = c.GetChunkSubframeBaseframe();
                for (j = 0; j < pom.length; ++j) {
                    if (pom[j] == null || !pom[j].equals(frame.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
            i = this.THEN.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                pom = c.GetChunkFrame();
                ind = false;
                for (j = 0; j < pom.length; ++j) {
                    if (!pom[j].equals(frame.trim())) continue;
                    ind = true;
                }
                pom = c.GetChunkSubframeBaseframe();
                for (j = 0; j < pom.length; ++j) {
                    if (pom[j] == null || !pom[j].equals(frame.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
        }
    }

    String GetIfClause(String chunk) throws Exception {
        if (chunk == null) {
            throw new RuleException(2, null);
        }
        for (Clause c : this.IF) {
            if (!c.GetChunkName().equals(chunk)) continue;
            return c.GetChunk();
        }
        throw new RuleException(21, chunk);
    }

    void DeleteIfClause(String chunk) throws Exception {
        if (chunk == null) {
            throw new RuleException(2, null);
        }
        Iterator i = this.IF.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Clause c = (Clause)i.next();
            if (!c.GetChunkName().equals(chunk)) continue;
            i.remove();
            ind = true;
        }
        if (!ind) {
            throw new RuleException(21, chunk);
        }
    }

    void DeleteClausesWithFrameSlot(String frame, String attribute) {
        if (frame != null && attribute != null) {
            int j;
            boolean ind;
            String[][] pom;
            Clause c;
            Iterator i = this.IF.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                pom = new String[3][0];
                pom[0] = c.GetChunkFrame();
                pom[1] = c.GetChunkSubframeBaseframe();
                pom[2] = c.GetChunkAttribute();
                ind = false;
                for (j = 0; j < pom[0].length; ++j) {
                    if (pom[0][j].equals(frame.trim()) && pom[2][j].equals(attribute.trim())) {
                        ind = true;
                        continue;
                    }
                    if (pom[1][j] == null || !pom[1][j].equals(frame.trim()) || !pom[2][j].equals(attribute.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
            i = this.THEN.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                pom = new String[3][0];
                pom[0] = c.GetChunkFrame();
                pom[1] = c.GetChunkSubframeBaseframe();
                pom[2] = c.GetChunkAttribute();
                ind = false;
                for (j = 0; j < pom[0].length; ++j) {
                    if (pom[0][j].equals(frame.trim()) && pom[2][j].equals(attribute.trim())) {
                        ind = true;
                        continue;
                    }
                    if (pom[1][j] == null || !pom[1][j].equals(frame.trim()) || !pom[2][j].equals(attribute.trim())) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
        }
    }

    void DeleteClausesWithSubframe(String frame, String subframe) {
        if (frame != null && subframe != null) {
            int j;
            boolean ind;
            String[][] pom;
            Clause c;
            Iterator i = this.IF.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                pom = new String[2][0];
                pom[1] = c.GetChunkSubframe();
                ind = false;
                for (j = 0; j < pom[1].length; ++j) {
                    if (pom[1][j] == null || !pom[1][j].equals(subframe.trim()) && !pom[1][j].startsWith(subframe.trim() + "[") && !pom[1][j].startsWith(subframe.trim() + ".") && pom[1][j].indexOf("." + subframe.trim() + "[") <= -1 && !pom[1][j].endsWith("." + subframe.trim()) && pom[1][j].indexOf("." + subframe.trim() + ".") <= -1) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
            i = this.THEN.iterator();
            while (i.hasNext()) {
                c = (Clause)i.next();
                pom = new String[2][0];
                pom[1] = c.GetChunkSubframe();
                ind = false;
                for (j = 0; j < pom[1].length; ++j) {
                    if (pom[1][j] == null || !pom[1][j].equals(subframe.trim()) && !pom[1][j].startsWith(subframe.trim() + ".") && !pom[1][j].endsWith("." + subframe.trim()) && pom[1][j].indexOf("." + subframe.trim() + ".") <= -1) continue;
                    ind = true;
                }
                if (!ind) continue;
                i.remove();
            }
        }
    }

    String GetThenClause(String chunk) throws Exception {
        if (chunk == null) {
            throw new RuleException(4, null);
        }
        for (Clause c : this.THEN) {
            if (!c.GetChunkName().equals(chunk)) continue;
            return c.GetChunk();
        }
        throw new RuleException(41, chunk);
    }

    void DeleteThenClause(String chunk) throws Exception {
        if (chunk == null) {
            throw new RuleException(4, null);
        }
        Iterator i = this.THEN.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Clause c = (Clause)i.next();
            if (!c.GetChunkName().equals(chunk)) continue;
            i.remove();
            ind = true;
        }
        if (!ind) {
            throw new RuleException(41, chunk);
        }
    }

    void EditIfClause(String oldchunk, KnowledgeChunk chunkref) throws Exception {
        if (oldchunk == null) {
            throw new RuleException(6, null);
        }
        if (chunkref == null) {
            throw new RuleException(7, null);
        }
        for (Clause c : this.IF) {
            if (!c.GetChunkName().equals(chunkref.GetName())) continue;
            throw new RuleException(3, chunkref.GetChunkAsString());
        }
        Iterator i = this.IF.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Clause c = (Clause)i.next();
            if (!c.GetChunkName().equals(oldchunk)) continue;
            c.SetChunk(chunkref);
            ind = true;
        }
        if (!ind) {
            throw new RuleException(22, oldchunk);
        }
    }

    String GetType() {
        if (this.OR) {
            return "OR";
        }
        return "AND";
    }

    String[] GetAllIfClauses() {
        String[] pom = new String[this.IF.size()];
        Iterator i = this.IF.iterator();
        int j = 0;
        while (i.hasNext()) {
            Clause c = (Clause)i.next();
            pom[j] = c.GetChunk();
            ++j;
        }
        return pom;
    }

    String[] GetAllThenClauses() {
        String[] pom = new String[this.THEN.size()];
        Iterator i = this.THEN.iterator();
        int j = 0;
        while (i.hasNext()) {
            Clause c = (Clause)i.next();
            pom[j] = c.GetChunk();
            ++j;
        }
        return pom;
    }

    String[][][] GetAllIfClauses2() {
        String[][][] pom = new String[this.IF.size()][0][0];
        Iterator i = this.IF.iterator();
        int j = 0;
        while (i.hasNext()) {
            Clause c = (Clause)i.next();
            pom[j] = c.GetChunk2();
            ++j;
        }
        return pom;
    }

    String[][][] GetAllThenClauses2() {
        String[][][] pom = new String[this.THEN.size()][0][0];
        Iterator i = this.THEN.iterator();
        int j = 0;
        while (i.hasNext()) {
            Clause c = (Clause)i.next();
            pom[j] = c.GetChunk2();
            ++j;
        }
        return pom;
    }

    String[][] GetRule() {
        String[][] pom = new String[5][0];
        pom[0] = new String[1];
        pom[0][0] = this.GetName();
        pom[1] = new String[1];
        pom[1][0] = this.GetType();
        pom[2] = this.GetAllIfClauses();
        pom[3] = this.GetAllThenClauses();
        pom[4] = new String[1];
        pom[4][0] = String.valueOf(this.importance);
        return pom;
    }

    String[][][][] GetRule2() {
        String[][][][] pom = new String[5][0][0][0];
        pom[0] = new String[1][1][1];
        pom[0][0][0][0] = this.GetName();
        pom[1] = new String[1][1][1];
        pom[1][0][0][0] = this.GetType();
        pom[2] = this.GetAllIfClauses2();
        pom[3] = this.GetAllThenClauses2();
        pom[4] = new String[1][1][1];
        pom[4][0][0][0] = String.valueOf(this.importance);
        return pom;
    }

    void SetType(String type) throws Exception {
        if (type == null) {
            throw new RuleException(8, null);
        }
        if (type.trim().equalsIgnoreCase("OR")) {
            this.OR = true;
        } else if (type.trim().equalsIgnoreCase("AND")) {
            this.OR = false;
        } else {
            throw new RuleException(9, type);
        }
    }

    void SetImportance(String importance) throws Exception {
        if (importance == null) {
            throw new RuleException(81, null);
        }
        try {
            this.importance = Double.parseDouble(importance);
        }
        catch (Exception e) {
            throw new RuleException(91, importance);
        }
    }

    void EditThenClause(String oldchunk, KnowledgeChunk chunkref) throws Exception {
        if (oldchunk == null) {
            throw new RuleException(10, null);
        }
        if (chunkref == null) {
            throw new RuleException(11, null);
        }
        for (Clause c : this.THEN) {
            if (!c.GetChunkName().equals(chunkref.GetName())) continue;
            throw new RuleException(5, chunkref.GetChunkAsString());
        }
        Iterator i = this.THEN.iterator();
        boolean ind = false;
        while (i.hasNext() && !ind) {
            Clause c = (Clause)i.next();
            if (!c.GetChunkName().equals(oldchunk)) continue;
            c.SetChunk(chunkref);
            ind = true;
        }
        if (!ind) {
            throw new RuleException(42, oldchunk);
        }
    }
}

