/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Attribute;
import don.Media;
import don.SlotException;
import don.WMElementException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import javax.imageio.ImageIO;

class Slot
implements Serializable {
    protected String[] question;
    protected Attribute attribute = null;
    protected String description = null;
    LinkedList media = new LinkedList();
    public static final String IMAGE_PATH = "RESOURCES";

    Slot() {
    }

    Slot(Attribute attributeref, String[] question, String description) throws Exception {
        if (attributeref == null) {
            throw new SlotException(0, null);
        }
        this.attribute = attributeref;
        this.question = question;
        this.description = description;
    }

    String GetAttributeName() {
        if (this.attribute == null) {
            return null;
        }
        return this.attribute.GetName();
    }

    Attribute GetAttributeReference() {
        return this.attribute;
    }

    String GetAttributeDomain() {
        return this.attribute.GetDomainName();
    }

    String[] GetQuestion() {
        return this.question;
    }

    void SetQuestion(String[] question) {
        this.question = question;
    }

    String GetDescription() {
        return this.description;
    }

    void SetDescription(String description) {
        this.description = description;
    }

    void SetAttribute(Attribute attributeref) throws Exception {
        if (attributeref == null) {
            throw new SlotException(0, null);
        }
        this.attribute = attributeref;
    }

    String[][] GetSlot() {
        if (this.attribute == null) {
            return null;
        }
        String[][] pom = new String[2 + this.media.size()][0];
        pom[0] = this.question;
        pom[1] = new String[2];
        pom[1][0] = this.attribute.GetName();
        pom[1][1] = this.description;
        Iterator i = this.media.iterator();
        int j = 2;
        while (i.hasNext()) {
            Media m = (Media)i.next();
            pom[j] = new String[2];
            pom[j][0] = m.GetName();
            pom[j][1] = m.GetPath();
            ++j;
        }
        return pom;
    }

    void AddMedia(String name, String path, boolean ucitavanje) throws Exception {
        if (name == null) {
            throw new SlotException(1, null);
        }
        for (Media pom : this.media) {
            if (!pom.GetName().equals(name.trim())) continue;
            throw new SlotException(2, name.trim());
        }
        if (!ucitavanje) {
            int idx;
            String base = null;
            char[] str = new char[]{(char)(97 + new Random().nextInt(26)), (char)(97 + new Random().nextInt(26)), (char)(97 + new Random().nextInt(26))};
            String abc = new String(str);
            File cpDestFile = null;
            File source = new File(path);
            if (source.isFile()) {
                cpDestFile = new File(IMAGE_PATH + File.separator + name + ".JPG");
                idx = cpDestFile.getName().lastIndexOf(".JPG");
                if (idx == cpDestFile.getName().length() - 4) {
                    base = cpDestFile.getName().substring(0, cpDestFile.getName().length() - 4);
                }
            } else {
                throw new SlotException(6, null);
            }
            if (!cpDestFile.exists()) {
                BufferedImage image = ImageIO.read(source);
                ImageIO.write((RenderedImage)image, "JPG", cpDestFile);
            } else {
                cpDestFile = new File(IMAGE_PATH + File.separator + name + abc + ".JPG");
                idx = cpDestFile.getName().lastIndexOf(".JPG");
                if (idx == cpDestFile.getName().length() - 4) {
                    base = cpDestFile.getName().substring(0, cpDestFile.getName().length() - 4);
                }
                BufferedImage image = ImageIO.read(source);
                ImageIO.write((RenderedImage)image, "JPG", cpDestFile);
            }
            this.media.addLast(new Media(base, cpDestFile.getPath()));
        } else {
            this.media.addLast(new Media(name, path));
        }
    }

    String[] GetMedia(String media) throws Exception {
        if (media == null) {
            throw new SlotException(3, null);
        }
        for (Media m : this.media) {
            if (!m.GetName().equals(media.trim())) continue;
            String[] pom = new String[]{m.GetName(), m.GetPath()};
            return pom;
        }
        throw new WMElementException(4, media.trim());
    }

    void DeleteMedia(String media) throws Exception {
        if (media == null) {
            throw new SlotException(3, null);
        }
        Iterator i = this.media.iterator();
        boolean ind = false;
        File cpDestFile = new File(IMAGE_PATH + File.separator + media + ".JPG");
        if (cpDestFile.exists()) {
            cpDestFile.delete();
        }
        while (i.hasNext() && !ind) {
            Media m = (Media)i.next();
            if (!m.GetName().equals(media.trim())) continue;
            i.remove();
            ind = true;
        }
        if (!ind) {
            throw new SlotException(4, media.trim());
        }
    }
}

