/*
 * Decompiled with CFR 0.152.
 */
package don.formulas;

import don.Attribute;
import don.Formula;
import java.io.Serializable;

public class TenPowerXFormula
extends Formula
implements Serializable {
    protected TenPowerXFormula() {
    }

    protected String GetName() {
        return "10^x";
    }

    protected String GetDescription() {
        return "operacija stepenovanja 10 (10^arg1)";
    }

    protected int GetArgumentCount() {
        return 1;
    }

    protected void CheckArguments(String tip, Object[][] args) throws Exception {
        if (!tip.equalsIgnoreCase("integer") && !tip.equalsIgnoreCase("float")) {
            throw new Exception("10^XFormula: return value is not the right type(integer and float only)");
        }
        if (args == null) {
            throw new Exception("10^XFormula: you must enter arguments");
        }
        if (args.length != 1) {
            throw new Exception("10^XFormula: you must enter one argument");
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length == 3) {
                Attribute a = (Attribute)args[i][2];
                String[][] pom = a.GetDomain();
                if (pom[1][0].equalsIgnoreCase(tip) || pom[1][0].equalsIgnoreCase("integer")) continue;
                throw new Exception("10^XFormula: arg" + (i + 1) + " is not the right type(" + tip + " only)");
            }
            String[][] v = (String[][])args[i][0];
            for (int j = 0; j < v.length; ++j) {
                if (tip.equalsIgnoreCase("integer")) {
                    try {
                        Integer.parseInt(v[j][0]);
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("10^XFormula: arg" + (i + 1) + " - value '" + v[j][0] + "' is not the right type(" + tip + " only)");
                    }
                }
                if (!tip.equalsIgnoreCase("float")) continue;
                try {
                    Double.parseDouble(v[j][0]);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("10^XFormula: arg" + (i + 1) + " - value '" + v[j][0] + "' is not the right type(" + tip + " only)");
                }
            }
        }
    }
}

