/**
 * @author "Nikola Milikic"
 * nikola.milikic@gmail.com
 * 
 * @author "Uros Krcadinac"
 * uros@krcadinac
 *
 * Intelligent Systems (FON, University of Belgrade) - http://is.fon.rs/
 * GOOD OLD AI Research Lab - http://goodoldai.org
 * 
 * WikipediaMiner
 * http://wikipedia-miner.cms.waikato.ac.nz/
 * 
 * Important paper about WikipediaMiner:
 * http://www.cs.waikato.ac.nz/~ihw/papers/12-DM-IHW-OStoolkit-wikimining.pdf 
 * 
 * December, 2013.
 * 
 */
package annotators;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

import org.apache.http.client.ClientProtocolException;

import util.HttpExecutor;

public class WikipediaMinerAnnotator implements Annotator {

	/*
	 * Annotation, getting concepts.
	 * @see annotators.Annotator#getConcepts(java.lang.String)
	 */
	@Override
	public String getConcepts(String text) {
		Map<String, String> parameters = new HashMap<String, String>();
		parameters.put("source", text);

		try {
			return HttpExecutor.executeHttpGet("http", "wikipedia-miner.cms.waikato.ac.nz", "/services/wikify", parameters);
		} catch (ClientProtocolException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (URISyntaxException e) {
			e.printStackTrace();
		}
		return null;
	}

	/*
	 * Comparison of 2 concepts, how the toolkit can reason  in a rough fashion  
	 * about what words mean and how they relate to each other.
	 * For how does it work see "3. Measuring relatedness" in:
	 * http://www.cs.waikato.ac.nz/~ihw/papers/12-DM-IHW-OStoolkit-wikimining.pdf
	 */
	public void compare(String term1, String term2) {
		Map<String, String> params = new HashMap<String, String>();
		params.put("term1", term1);
		params.put("term2", term2);

		try {
			String s = HttpExecutor.executeHttpGet("http", "wikipedia-miner.cms.waikato.ac.nz", "/services/compare", params);
			System.out.println(s);
			
			// Parsing the comparison data 
			int indexOfRelatedness = s.indexOf("relatedness=\"")+13;
			double relatedness = Double.valueOf(s.substring(indexOfRelatedness, s.indexOf("\"", indexOfRelatedness)));
			System.out.println("relatedness: " + relatedness);

			int indexOfDisambiguation = s.indexOf("disambiguationConfidence=\"") + 26;
			double disambiguationConfidence = Double.valueOf(s.substring(indexOfDisambiguation, s.indexOf("\"", indexOfDisambiguation)));
			System.out.println("disambiguationConfidence: "+disambiguationConfidence);
		} catch (ClientProtocolException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (URISyntaxException e) {
			e.printStackTrace();
		}
	}
}
