/**
 * @author "Nikola Milikic"
 * nikola.milikic@gmail.com
 * 
 * @author "Uros Krcadinac"
 * uros@krcadinac
 *
 * Intelligent Systems (FON, University of Belgrade) - http://is.fon.rs/
 * GOOD OLD AI Research Lab - http://goodoldai.org
 * 
 * December, 2013.
 * 
 */
package main;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;

import util.HttpExecutor;
import annotators.Annotator;
import annotators.DBpediaSpotlightAnnotator;
import annotators.TagmeAnnotator;
import annotators.WikipediaMinerAnnotator;

public class StartAnnotators {

	public static void main(String[] args) {
		//Annotator annotator = new DBpediaSpotlightAnnotator();
		//Annotator annotator = new TagmeAnnotator();
		Annotator annotator = new WikipediaMinerAnnotator();
		
		/*
		 * Query text example
		 */
		String text = "At around the size of a domestic chicken, kiwi are by far the smallest " +
				"living ratites and lay the largest egg in relation to their body size of any " +
				"species of bird in the world.";
		
		System.out.println(annotator.getConcepts(text));
		
		//testSpotlight();
		
		// Compare terms
		//new WikipediaMinerAnnotator().compare("kiwi", "takahe");
	}

}
