/**
 * @author "Nikola Milikic"
 * nikola.milikic@gmail.com
 * 
 * @author "Uros Krcadinac"
 * uros@krcadinac
 *
 * Intelligent Systems (FON, University of Belgrade) - http://is.fon.rs/
 * GOOD OLD AI Research Lab - http://goodoldai.org
 *
 * DBpedia:
 * http://www.informatik.uni-leipzig.de/~auer/presentations/dbpedia/
 * 
 * DBpedia presentation:
 * http://www.informatik.uni-leipzig.de/~auer/presentations/dbpedia/
 * 
 */
package annotators;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

import org.apache.http.client.ClientProtocolException;

import util.HttpExecutor;

public class DBpediaSpotlightAnnotator implements Annotator {
	
	/*
	 * Setting the parameters
	 */
	public static final double confidence = 0.25; 
	public static final int support = 30;	
	
	/*
	 * Annotation:
	 * https://github.com/dbpedia-spotlight/dbpedia-spotlight/wiki/Web-service
	 * @see annotators.Annotator#getConcepts(java.lang.String)
	 */
	@Override
	public String getConcepts(String text) {
		try {
			Map<String, String> params = new HashMap<String, String>();
			params.put("confidence", String.valueOf(confidence));
			params.put("support", String.valueOf(support));
			params.put("text", text);

			return HttpExecutor.executePost("http://spotlight.dbpedia.org/rest/annotate/", params);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (ClientProtocolException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}	
		return null;
	}

}

