/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.file.BlockAccess;
import com.hp.hpl.jena.tdb.base.file.FileBase;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.openjena.atlas.lib.FileOps;
import org.slf4j.Logger;

public abstract class BlockAccessBase
implements BlockAccess {
    protected final int blockSize;
    protected final FileBase file;
    protected final String label;
    protected long numFileBlocks = -1L;
    protected final AtomicLong seq;
    protected boolean isEmpty = false;

    public BlockAccessBase(String filename, int blockSize) {
        this.file = FileBase.create(filename);
        this.blockSize = blockSize;
        this.label = FileOps.basename((String)filename);
        long filesize = this.file.size();
        long longBlockSize = blockSize;
        this.numFileBlocks = filesize / longBlockSize;
        this.seq = new AtomicLong(this.numFileBlocks);
        if (this.numFileBlocks > Integer.MAX_VALUE) {
            this.getLog().warn(String.format("File size (%d) exceeds tested block number limits (%d)", filesize, blockSize));
        }
        if (filesize % longBlockSize != 0L) {
            throw new BlockException(String.format("File size (%d) not a multiple of blocksize (%d)", filesize, blockSize));
        }
        if (filesize == 0L) {
            this.isEmpty = true;
        }
    }

    protected abstract Logger getLog();

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    protected final void writeNotification(Block block) {
        this.isEmpty = false;
    }

    protected final void overwriteNotification(Block block) {
        if (block.getId() >= this.numFileBlocks) {
            this.numFileBlocks = block.getId() + 1L;
            this.seq.set(this.numFileBlocks);
        }
    }

    protected final int allocateId() {
        this.checkIfClosed();
        int id = (int)this.seq.getAndIncrement();
        ++this.numFileBlocks;
        return id;
    }

    @Override
    public final synchronized boolean valid(long id) {
        if (id >= this.numFileBlocks) {
            return false;
        }
        return id >= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void check(long id) {
        if (id > Integer.MAX_VALUE) {
            throw new BlockException(String.format("BlockAccessBase: Id (%d) too large", id));
        }
        if (id < 0L || id >= this.numFileBlocks) {
            BlockAccessBase blockAccessBase = this;
            synchronized (blockAccessBase) {
                if (id < 0L || id >= this.numFileBlocks) {
                    throw new BlockException(String.format("BlockAccessBase: Bounds exception: %s: (%d,%d)", this.file.filename, id, this.numFileBlocks));
                }
            }
        }
    }

    protected final void check(Block block) {
        this.check(block.getId());
        ByteBuffer bb = block.getByteBuffer();
        if (bb.capacity() != this.blockSize) {
            throw new BlockException(String.format("BlockMgrFile: Wrong size block.  Expected=%d : actual=%d", this.blockSize, bb.capacity()));
        }
        if (bb.order() != SystemTDB.NetworkOrder) {
            throw new BlockException("BlockMgrFile: Wrong byte order");
        }
    }

    protected void force() {
        this.file.sync();
    }

    public final boolean isClosed() {
        return this.file.channel() == null;
    }

    protected final void checkIfClosed() {
        if (this.isClosed()) {
            this.getLog().error("File has been closed");
        }
    }

    protected abstract void _close();

    public final void close() {
        this._close();
        this.file.close();
    }

    @Override
    public String getLabel() {
        return this.label;
    }
}

