/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDBBase;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.sys.TDBInternal;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphNamedTDB
extends GraphTDBBase {
    private static Logger log = LoggerFactory.getLogger(GraphNamedTDB.class);
    private final QuadTable quadTable;
    private NodeId graphNodeId = null;
    private static Transform<Tuple<NodeId>, Tuple<NodeId>> project4TupleTo3Tuple = new Transform<Tuple<NodeId>, Tuple<NodeId>>(){

        public Tuple<NodeId> convert(Tuple<NodeId> item) {
            if (item.size() != 4) {
                throw new TDBException("Expected a Tuple of 4, got: " + item);
            }
            return Tuple.create((Object[])new NodeId[]{(NodeId)item.get(1), (NodeId)item.get(2), (NodeId)item.get(3)});
        }
    };

    public GraphNamedTDB(DatasetGraphTDB dataset, Node graphName) {
        super(dataset, graphName);
        this.quadTable = dataset.getQuadTable();
        if (graphName == null) {
            throw new TDBException("GraphNamedTDB: Null graph name");
        }
        if (!graphName.isURI()) {
            throw new TDBException("GraphNamedTDB: Graph name not a URI - " + graphName.toString());
        }
    }

    protected PrefixMapping createPrefixMapping() {
        return this.dataset.getPrefixes().getPrefixMapping(this.graphNode.getURI());
    }

    @Override
    protected boolean _performAdd(Triple t) {
        if (Quad.isUnionGraph((Node)this.graphNode)) {
            throw new TDBException("Can't add a triple to the RDF merge of all named graphs");
        }
        boolean changed = Quad.isDefaultGraph((Node)this.graphNode) ? this.dataset.getTripleTable().add(t) : this.dataset.getQuadTable().add(this.graphNode, t);
        if (!changed) {
            this.duplicate(t);
        }
        return changed;
    }

    @Override
    protected boolean _performDelete(Triple t) {
        if (Quad.isUnionGraph((Node)this.graphNode)) {
            throw new TDBException("Can't delete triple from the RDF merge of all named graphs");
        }
        if (Quad.isDefaultGraph((Node)this.graphNode)) {
            return this.dataset.getTripleTable().delete(t);
        }
        return this.dataset.getQuadTable().delete(this.graphNode, t);
    }

    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        if (Quad.isDefaultGraph((Node)this.graphNode)) {
            return GraphNamedTDB.graphBaseFindDft(this.getDataset(), m);
        }
        return GraphNamedTDB.graphBaseFindNG(this.getDataset(), this.graphNode, m);
    }

    protected Iterator<Tuple<NodeId>> countThis() {
        NodeId gn;
        NodeId nodeId = gn = Quad.isUnionGraph((Node)this.graphNode) ? null : this.getGraphNodeId();
        if (NodeId.isDoesNotExist(gn)) {
            return Iter.nullIterator();
        }
        Iterator iter = this.dataset.getQuadTable().getNodeTupleTable().find(gn, null, null, null);
        if (Quad.isUnionGraph((Node)this.graphNode)) {
            iter = Iter.map(iter, project4TupleTo3Tuple);
            iter = Iter.distinct((Iterator)iter);
        }
        return iter;
    }

    private final NodeId getGraphNodeId() {
        if (this.graphNodeId == null || this.graphNodeId == NodeId.NodeDoesNotExist) {
            NodeId n;
            this.graphNodeId = n = TDBInternal.getNodeId((DatasetGraph)this.dataset, this.graphNode);
        }
        return this.graphNodeId;
    }

    @Override
    protected final Logger getLog() {
        return log;
    }

    @Override
    public NodeTupleTable getNodeTupleTable() {
        if (this.graphNode == null || Quad.isDefaultGraph((Node)this.graphNode)) {
            return this.dataset.getTripleTable().getNodeTupleTable();
        }
        return this.dataset.getQuadTable().getNodeTupleTable();
    }

    public final void close() {
        this.sync();
    }

    @Override
    public void sync() {
        this.dataset.sync();
    }

    @Override
    public String toString() {
        return Utils.className((Object)this) + ":<" + this.graphNode + ">";
    }
}

