/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetPrefixStorage;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDBBase;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import org.openjena.atlas.lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphTriplesTDB
extends GraphTDBBase {
    private static Logger log = LoggerFactory.getLogger(GraphTriplesTDB.class);
    private final TripleTable tripleTable;
    private final DatasetPrefixStorage prefixes;

    public GraphTriplesTDB(DatasetGraphTDB dataset, TripleTable tripleTable, DatasetPrefixStorage prefixes) {
        super(dataset, null);
        this.tripleTable = tripleTable;
        this.prefixes = prefixes;
    }

    @Override
    protected boolean _performAdd(Triple t) {
        boolean changed = this.tripleTable.add(t);
        if (!changed) {
            this.duplicate(t);
        }
        return changed;
    }

    @Override
    protected boolean _performDelete(Triple t) {
        boolean changed = this.tripleTable.delete(t);
        return changed;
    }

    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        return GraphTriplesTDB.graphBaseFindDft(this.dataset, m);
    }

    @Override
    protected final Logger getLog() {
        return log;
    }

    protected Iterator<Tuple<NodeId>> countThis() {
        return this.tripleTable.getNodeTupleTable().findAll();
    }

    @Override
    public NodeTupleTable getNodeTupleTable() {
        return this.tripleTable.getNodeTupleTable();
    }

    protected PrefixMapping createPrefixMapping() {
        return this.prefixes.getPrefixMapping();
    }

    public final void close() {
        if (this.dataset != null) {
            this.sync();
        } else {
            this.prefixes.close();
            this.tripleTable.close();
            super.close();
        }
    }

    @Override
    public void sync() {
        if (this.dataset != null) {
            this.dataset.sync();
        } else {
            this.prefixes.sync();
            this.tripleTable.sync();
        }
    }

    @Override
    public String toString() {
        return Utils.className((Object)this);
    }
}

