/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderLib;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.FileMode;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.IndexType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Properties;
import org.openjena.atlas.lib.PropertyUtils;
import org.openjena.atlas.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTDB {
    private static final Logger log = LoggerFactory.getLogger(TDB.class);
    public static final Logger syslog = LoggerFactory.getLogger((String)"TDB");
    public static final Logger errlog = LoggerFactory.getLogger((String)"TDB");
    public static final int SizeOfLong = 8;
    public static final int SizeOfInt = 4;
    public static final int SizeOfNodeId = 8;
    public static final int SizeOfPointer = 4;
    public static final int LenIndexTripleRecord = 24;
    public static final int LenIndexQuadRecord = 32;
    public static final int LenNodeHash = 16;
    public static final RecordFactory indexRecordTripleFactory = new RecordFactory(24, 0);
    public static final RecordFactory indexRecordQuadFactory = new RecordFactory(32, 0);
    public static final RecordFactory nodeRecordFactory = new RecordFactory(16, 8);
    public static final String symbolNamespace = "http://jena.hpl.hp.com/TDB#";
    public static final String tdbSymbolPrefix = "tdb";
    public static final String tdbPropertyRoot = "com.hp.hpl.jena.tdb";
    public static final Symbol symLogDuplicates = SystemTDB.allocSymbol("logDuplicates");
    public static final Symbol symFileMode = SystemTDB.allocSymbol("fileMode");
    public static final Symbol symIndexType = SystemTDB.allocSymbol("indexType");
    public static final Symbol symTupleFilter = SystemTDB.allocSymbol("tupleFilter");
    private static final String propertyFileKey1 = "com.hp.hpl.jena.tdb.settings";
    private static final String propertyFileKey2 = "tdb:settings";
    private static String propertyFileName = null;
    public static final boolean is64bitSystem;
    private static Properties properties;
    public static final int BlockSize = 8192;
    public static final int BlockSizeTest = 1024;
    public static final int BlockSizeTestMem = 500;
    public static final int OrderMem = 5;
    public static Properties global;
    public static final int SegmentSize = 0x800000;
    public static final int ObjectFileWriteCacheSize = 8192;
    public static final int Node2NodeIdCacheSize;
    public static final int NodeId2NodeCacheSize;
    public static final int NodeMissCacheSize = 100;
    public static final int BlockWriteCacheSize;
    public static final int BlockReadCacheSize;
    public static ReorderTransformation defaultOptimizer;
    public static final ByteOrder NetworkOrder;
    public static boolean NullOut;
    public static final byte FillByte = -1;
    public static boolean Checking;
    public static final boolean isWindows;
    private static FileMode fileMode;
    public static final String indexTypeBTree = "BTree";
    public static final String indexTypeBPlusTree = "BPlusTree";
    public static final String indexTypeExtHash = "ExtHash";
    public static final String defaultIndexType = "BPlusTree";
    private static IndexType indexType;

    public static void init() {
    }

    public static void panic(Class<?> clazz, String string) {
        Log.fatal(clazz, (String)string);
        throw new TDBException(string);
    }

    public static Symbol allocSymbol(String shortName) {
        if (shortName.startsWith(tdbSymbolPrefix)) {
            throw new TDBException("Symbol short name begins with the TDB namespace prefix: " + shortName);
        }
        if (shortName.startsWith("http:")) {
            throw new TDBException("Symbol short name begins with http: " + shortName);
        }
        return SystemTDB.allocSymbol(symbolNamespace, shortName);
    }

    private static Symbol allocSymbol(String namespace, String shortName) {
        return Symbol.create((String)(namespace + shortName));
    }

    private static int intValue(String prefix, String name, int defaultValue) {
        name = !prefix.endsWith(".") ? prefix + "." + name : prefix + name;
        return SystemTDB.intValue(name, defaultValue);
    }

    private static int intValue(String name, int defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        if (name.length() == 0) {
            throw new TDBException("Empty string for value name");
        }
        if (properties == null) {
            return defaultValue;
        }
        String x = properties.getProperty(name);
        if (x == null) {
            return defaultValue;
        }
        TDB.logInfo.info("Set: " + name + " = " + x);
        int v = Integer.parseInt(x);
        return v;
    }

    private static Properties readPropertiesFile() {
        if (propertyFileName == null) {
            return null;
        }
        Properties p = new Properties();
        try {
            TDB.logInfo.info("Using properties from '" + propertyFileName + "'");
            PropertyUtils.loadFromFile((Properties)p, (String)propertyFileName);
        }
        catch (FileNotFoundException ex) {
            log.debug("No system properties file (" + propertyFileName + ")");
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return p;
    }

    private static boolean determineIfWindows() {
        String s = System.getProperty("os.name");
        if (s == null) {
            return false;
        }
        return s.startsWith("Windows ");
    }

    private static boolean determineIf64Bit() {
        String s = System.getProperty("sun.arch.data.model");
        if (s != null) {
            boolean b = s.equals("64");
            TDB.logInfo.debug("System architecture: " + (b ? "64 bit" : "32 bit"));
            return b;
        }
        s = System.getProperty("java.vm.info");
        if (s == null) {
            log.warn("Can't determine the data model");
            return false;
        }
        log.debug("Can't determine the data model from 'sun.arch.data.model' - using java.vm.info");
        boolean b = s.contains("64");
        TDB.logInfo.debug("System architecture: (from java.vm.info) " + (b ? "64 bit" : "32 bit"));
        return b;
    }

    public static FileMode fileMode() {
        if (fileMode == null) {
            fileMode = SystemTDB.determineFileMode();
        }
        return fileMode;
    }

    public static void setFileMode(FileMode newFileMode) {
        if (fileMode != null) {
            log.warn("System file mode already determined - setting it has no effect");
            return;
        }
        fileMode = newFileMode;
    }

    static void internalSetFileMode(FileMode newFileMode) {
        fileMode = newFileMode;
    }

    private static FileMode determineFileMode() {
        String x = ARQ.getContext().getAsString(symFileMode, "default");
        if (x.equalsIgnoreCase("direct")) {
            TDB.logInfo.info("File mode: direct (forced)");
            return FileMode.direct;
        }
        if (x.equalsIgnoreCase("mapped")) {
            TDB.logInfo.info("File mode: mapped (forced)");
            return FileMode.mapped;
        }
        if (x.equalsIgnoreCase("default")) {
            if (is64bitSystem) {
                TDB.logInfo.debug("File mode: Mapped");
                return FileMode.mapped;
            }
            TDB.logInfo.debug("File mode: Direct");
            return FileMode.direct;
        }
        throw new TDBException("Unrecognized file mode (not one of 'default', 'direct' or 'mapped': " + x);
    }

    public static IndexType getIndexType() {
        if (indexType != null) {
            return indexType;
        }
        boolean defaultSetting = false;
        String x = TDB.getContext().getAsString(symIndexType);
        if (x == null) {
            defaultSetting = true;
            x = "BPlusTree";
        }
        IndexType iType = IndexType.get(x);
        if (!defaultSetting) {
            LoggerFactory.getLogger(IndexType.class).info("Index type: " + (Object)((Object)iType));
        }
        indexType = iType;
        return iType;
    }

    static {
        propertyFileName = System.getProperty(propertyFileKey1);
        if (propertyFileName == null) {
            propertyFileName = System.getProperty(propertyFileKey2);
        }
        is64bitSystem = SystemTDB.determineIf64Bit();
        properties = SystemTDB.readPropertiesFile();
        global = new Properties();
        Node2NodeIdCacheSize = SystemTDB.intValue("Node2NodeIdCacheSize", is64bitSystem ? 100000 : 50000);
        NodeId2NodeCacheSize = SystemTDB.intValue("NodeId2NodeCacheSize", is64bitSystem ? 500000 : 50000);
        BlockWriteCacheSize = SystemTDB.intValue("BlockWriteCacheSize", 2000);
        BlockReadCacheSize = SystemTDB.intValue("BlockReadCacheSize", 10000);
        defaultOptimizer = ReorderLib.fixed();
        NetworkOrder = ByteOrder.BIG_ENDIAN;
        NullOut = false;
        Checking = false;
        isWindows = SystemTDB.determineIfWindows();
        fileMode = null;
        indexType = null;
    }
}

