/*
 * Decompiled with CFR 0.152.
 */
package tdb.cmdline;

import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdARQ;
import com.hp.hpl.jena.Jena;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.setup.DatasetBuilderStd;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.TDBInternal;
import org.openjena.atlas.logging.Log;
import tdb.cmdline.ModTDBDataset;

public abstract class CmdTDB
extends CmdARQ {
    protected final ModTDBDataset tdbDatasetAssembler = new ModTDBDataset();
    private static boolean initialized = false;

    protected CmdTDB(String[] argv) {
        super(argv);
        CmdTDB.init();
        super.addModule((ArgModuleGeneral)this.tdbDatasetAssembler);
        this.modVersion.addClass(Jena.class);
        this.modVersion.addClass(ARQ.class);
        this.modVersion.addClass(TDB.class);
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        Log.setCmdLogging();
        TDB.init();
        DatasetBuilderStd.setOptimizerWarningFlag(false);
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
    }

    protected Location getLocation() {
        return this.tdbDatasetAssembler.getLocation();
    }

    protected DatasetGraph getDatasetGraph() {
        return this.getDataset().asDatasetGraph();
    }

    protected DatasetGraphTDB getDatasetGraphTDB() {
        DatasetGraph dsg = this.getDatasetGraph();
        return TDBInternal.getBaseDatasetGraphTDB(dsg);
    }

    protected Dataset getDataset() {
        return this.tdbDatasetAssembler.getDataset();
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }
}

