/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import org.openjena.atlas.logging.Log;

public class ElementService
extends Element {
    private final Node serviceNode;
    private final Element element;
    private final boolean silent;

    public ElementService(String serviceURI, Element el) {
        this(Node.createURI((String)serviceURI), el, false);
    }

    public ElementService(String serviceURI, Element el, boolean silent) {
        this(Node.createURI((String)serviceURI), el, silent);
    }

    public ElementService(Node n, Element el, boolean silent) {
        if (!n.isURI() && !n.isVariable()) {
            Log.fatal(this, "Must be a URI (or variable which will be bound) for a service endpoint");
        }
        this.serviceNode = n;
        this.element = el;
        this.silent = silent;
    }

    public Element getElement() {
        return this.element;
    }

    public Node getServiceNode() {
        return this.serviceNode;
    }

    public String getServiceURI() {
        return this.serviceNode.getURI();
    }

    public boolean getSilent() {
        return this.silent;
    }

    @Override
    public int hashCode() {
        return this.serviceNode.hashCode() ^ this.element.hashCode();
    }

    @Override
    public boolean equalTo(Element el2, NodeIsomorphismMap isoMap) {
        if (!(el2 instanceof ElementService)) {
            return false;
        }
        ElementService service = (ElementService)el2;
        if (!this.serviceNode.equals((Object)service.serviceNode)) {
            return false;
        }
        if (service.getSilent() != this.getSilent()) {
            return false;
        }
        return this.getElement().equalTo(service.getElement(), isoMap);
    }

    @Override
    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

