/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.lang.arq.ARQParser;
import com.hp.hpl.jena.sparql.lang.arq.ParseException;
import com.hp.hpl.jena.sparql.lang.arq.Token;
import com.hp.hpl.jena.sparql.lang.arq.TokenMgrError;
import com.hp.hpl.jena.sparql.serializer.FmtExprSPARQL;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.sse.builders.ExprBuildException;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import java.io.StringReader;
import java.util.List;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;

public class ExprUtils {
    public static Expr nodeToExpr(Node n) {
        if (n.isVariable()) {
            return new ExprVar(n);
        }
        return NodeValue.makeNode(n);
    }

    public static String joinList(List<Expr> args, String sep) {
        if (args == null) {
            return "<<Null list>>";
        }
        if (args.size() == 0) {
            return "<<Empty list>>";
        }
        StringBuffer s = new StringBuffer();
        boolean first = true;
        for (Expr ex : args) {
            if (!first) {
                s.append(sep);
            }
            if (ex instanceof NodeValue) {
                NodeValue nv = (NodeValue)ex;
                s.append(nv.asQuotedString());
            } else {
                s.append(ex.toString());
            }
            first = false;
        }
        return s.toString();
    }

    public static Expr parse(String s) {
        return ExprUtils.parse(s, ARQConstants.getGlobalPrefixMap());
    }

    public static Expr parse(String s, PrefixMapping pmap) {
        Query query2 = QueryFactory.make();
        query2.setPrefixMapping(pmap);
        return ExprUtils.parse(query2, s, true);
    }

    public static Expr parse(Query query2, String s, boolean checkAllUsed) {
        try {
            StringReader in = new StringReader(s);
            ARQParser parser = new ARQParser(in);
            parser.setQuery(query2);
            Expr expr = parser.Expression();
            if (checkAllUsed) {
                Token t = parser.getNextToken();
                if (t.kind != 0) {
                    throw new QueryParseException("Extra tokens beginning \"" + t.image + "\" starting line " + t.beginLine + ", column " + t.beginColumn, t.beginLine, t.beginColumn);
                }
            }
            return expr;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginLine);
        }
        catch (TokenMgrError tErr) {
            throw new QueryParseException(tErr.getMessage(), -1, -1);
        }
        catch (Error err) {
            String tmp = err.getMessage();
            if (tmp == null) {
                throw new QueryParseException(err, -1, -1);
            }
            throw new QueryParseException(tmp, -1, -1);
        }
    }

    public static NodeValue parseNodeValue(String s) {
        Node n = NodeFactory.parseNode(s);
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    public static void fmtSPARQL(IndentedWriter iOut, Expr expr, SerializationContext sCxt) {
        FmtExprSPARQL v = new FmtExprSPARQL(iOut, sCxt);
        v.format(expr);
    }

    public static void fmtSPARQL(IndentedWriter iOut, Expr expr) {
        ExprUtils.fmtSPARQL(iOut, expr, FmtUtils.sCxt());
    }

    public static String fmtSPARQL(Expr expr) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtSPARQL((IndentedWriter)buff, expr);
        return buff.toString();
    }

    public static void fmtSPARQL(IndentedWriter iOut, ExprList exprs, SerializationContext pmap) {
        FmtExprSPARQL fmt = new FmtExprSPARQL(iOut, pmap);
        String sep = "";
        for (Expr expr : exprs) {
            iOut.print(sep);
            sep = " , ";
            fmt.format(expr);
        }
    }

    public static void fmtSPARQL(IndentedWriter iOut, ExprList exprs) {
        ExprUtils.fmtSPARQL(iOut, exprs, FmtUtils.sCxt());
    }

    public static String fmtSPARQL(ExprList exprs) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtSPARQL((IndentedWriter)buff, exprs);
        return buff.toString();
    }

    public static String strComparison(int cmp) {
        switch (cmp) {
            case 1: {
                return "GT";
            }
            case 0: {
                return "EQ";
            }
            case -1: {
                return "LT";
            }
            case 2: {
                return "indeterminate";
            }
        }
        return "??";
    }

    public static void expr(String exprStr) {
        ExprUtils.expr(exprStr, null);
    }

    public static void expr(String exprStr, Binding binding) {
        try {
            Expr expr = ExprUtils.parse(exprStr, ARQConstants.getGlobalPrefixMap());
            ExprUtils.evalPrint(expr, binding);
        }
        catch (QueryParseException ex) {
            System.err.println("Parse error: " + ex.getMessage());
            return;
        }
    }

    public static void exprPrefix(String exprStr) {
        ExprUtils.exprPrefix(exprStr, null);
    }

    public static void evalPrint(Expr expr, Binding binding) {
        try {
            NodeValue r = ExprUtils.eval(expr, binding);
            Node n = r.asNode();
            String s = FmtUtils.stringForNode(n);
            System.out.println(s);
        }
        catch (ExprEvalException ex) {
            System.out.println("Exception: " + ex.getMessage());
            return;
        }
        catch (ExprBuildException ex) {
            System.err.println("Build exception: " + ex.getMessage());
            return;
        }
    }

    public static NodeValue eval(Expr expr) {
        return ExprUtils.eval(expr, BindingRoot.create());
    }

    public static NodeValue eval(Expr expr, Binding binding) {
        Context context = ARQ.getContext().copy();
        context.set(ARQConstants.sysCurrentTime, NodeFactory.nowAsDateTime());
        ExecutionContext env = new ExecutionContext(context, null, null, null);
        NodeValue r = expr.eval(binding, env);
        return r;
    }

    public static void exprPrefix(String string, Binding binding) {
        try {
            Expr expr = SSE.parseExpr(string);
            ExprUtils.evalPrint(expr, binding);
        }
        catch (SSEParseException ex) {
            System.err.println("Parse error: " + ex.getMessage());
            return;
        }
    }
}

