/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.TypedStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.atlas.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentNeg {
    private static Logger log;
    static String InternalNTriples;
    static Map<String, String> extToMimeType;
    static Map<String, String> readers;
    static String acceptHeaderValue;

    public static void main(String ... args) throws Exception {
        ContentNeg.dwim("http://topbraid.org/examples/kennedys");
        ContentNeg.dwim("http://dbpedia.org/resource/Fred");
        System.exit(0);
    }

    static void dwim(String url) throws Exception {
        log.info("URL = " + url);
        TypedStream typedStream = ContentNeg.negotiateHTTP(url);
        log.info("MIME type:   " + typedStream.getMimeType());
        log.info("Content type: " + typedStream.getCharset());
        typedStream.getInput().close();
    }

    public final void read(Model model, String url, String baseIRI) {
    }

    private static void init() {
        extToMimeType.put("n3", "text/rdf+n3");
        extToMimeType.put("ttl", "text/turtle");
        extToMimeType.put("nt", InternalNTriples);
        extToMimeType.put("rdf", "application/rdf+xml");
        extToMimeType.put("owl", "application/rdf+xml");
        extToMimeType.put("xml", "application/rdf+xml");
        readers.put("application/rdf+xml", "RDF/XML");
        readers.put("text/rdf+n3", "N3");
        readers.put("application/n3", "N3");
        readers.put("text/n3", "N3");
        readers.put("text/turtle", "TURTLE");
        readers.put("application/turtle", "TURTLE");
        readers.put("application/x-turtle", "TURTLE");
        readers.put("text/plain", "NT");
        readers.put(InternalNTriples, "NT");
        readers.put("application/rss+xml", "RDF/XML");
    }

    public static TypedStream negotiateFilename(String filename) throws IOException {
        InputStream in;
        if (filename.startsWith("file:")) {
            // empty if block
        }
        if ((in = IO.openFile(filename)) == null) {
            return null;
        }
        String fn = filename;
        boolean isGZipped = false;
        if (filename.endsWith(".gz")) {
            isGZipped = true;
            int x = filename.length();
            fn = filename.substring(x - 3);
        }
        String suffix = FileUtils.getFilenameExt((String)fn);
        String mimeType = extToMimeType.get(suffix);
        return new TypedStream(in, mimeType, null);
    }

    public static String guessMIMETypeFromFilename(String filename) {
        String suffix;
        String mimeType;
        String fn = filename;
        if (filename.endsWith(".gz")) {
            int x = filename.length();
            fn = filename.substring(x - 3);
        }
        mimeType = (mimeType = extToMimeType.get(suffix = FileUtils.getFilenameExt((String)fn))) == null ? "application/rdf+xml" : mimeType.toLowerCase();
        return mimeType;
    }

    public static TypedStream negotiateHTTP(String url) throws IOException {
        int i;
        if (!url.startsWith("http://")) {
            return null;
        }
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        HttpURLConnection.setFollowRedirects(true);
        con.setRequestProperty("Accept", acceptHeaderValue);
        con.setRequestProperty("Accept-Encoding", "gzip,deflate");
        con.setRequestProperty("Connection", "keep-alive");
        con.connect();
        String contentEncoding = con.getContentEncoding();
        if (log.isDebugEnabled()) {
            log.debug("Content-Encoding: " + contentEncoding);
        }
        InputStream stream = con.getInputStream();
        if (contentEncoding != null) {
            if (contentEncoding.equalsIgnoreCase("deflate")) {
                stream = new InflaterInputStream(stream);
            } else if (contentEncoding.equalsIgnoreCase("gzip")) {
                stream = new GZIPInputStream(stream);
            } else {
                Log.warn(ContentNeg.class, "Unsupported ContentEncoding: " + contentEncoding);
            }
        }
        String x = con.getContentType();
        String contentType = null;
        String charset = null;
        if (x.contains(";")) {
            String[] xx = x.split("\\s*;\\s*");
            contentType = xx[0];
            charset = xx[1];
        } else {
            contentType = x;
        }
        if (log.isDebugEnabled()) {
            log.debug(contentType + " ;; " + charset);
        }
        if (charset != null && (i = charset.indexOf("charset=")) == 0) {
            charset = charset.substring("charset=".length());
        }
        if (contentType != null) {
            contentType = contentType.toLowerCase();
        }
        if ("text/plain".equals(contentType) && !url.endsWith(".nt") && !url.endsWith(".nt.gz")) {
            contentType = null;
        }
        if (contentType == null) {
            contentType = "application/rdf+xml";
        }
        return new TypedStream(stream, contentType, charset);
    }

    static {
        Log.setLog4j();
        log = LoggerFactory.getLogger(ContentNeg.class);
        InternalNTriples = "text/plain";
        extToMimeType = new HashMap<String, String>();
        readers = new HashMap<String, String>();
        ContentNeg.init();
        acceptHeaderValue = StrUtils.strjoin(",", "application/rdf+xml", "application/turtle;q=0.9", "application/x-turtle;q=0.9", "text/n3;q=0.8", "text/turtle;q=0.8", "text/rdf+n3;q=0.7", "application/xml;q=0.5", "text/xml;q=0.5", "text/plain;q=0.4", "*/*;q=0.2");
    }
}

