/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.http;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.http.Params;
import com.hp.hpl.jena.sparql.engine.http.QueryExceptionHTTP;
import com.hp.hpl.jena.sparql.util.Convert;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.regex.Pattern;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.openjena.atlas.lib.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpQuery
extends Params {
    static final Logger log = LoggerFactory.getLogger((String)HttpQuery.class.getName());
    public static int urlLimit = 2048;
    String serviceURL;
    String contentTypeResult = "application/sparql-results+xml";
    HttpURLConnection httpConnection = null;
    static final Object noValue = new Object();
    String user = null;
    char[] password = null;
    int responseCode = 0;
    String responseMessage = null;
    boolean forcePOST = false;
    String queryString = null;
    boolean serviceParams = false;
    private final Pattern queryParamPattern = Pattern.compile(".+[&|\\?]query=.*");
    int connectTimeout = 0;
    int readTimeout = 0;
    private boolean allowGZip = false;
    private boolean allowDeflate = false;

    public HttpQuery(String serviceURL) {
        this.init(serviceURL);
    }

    public HttpQuery(URL url) {
        this.init(url.toString());
    }

    private void init(String serviceURL) {
        if (log.isTraceEnabled()) {
            log.trace("URL: " + serviceURL);
        }
        if (serviceURL.indexOf(63) >= 0) {
            this.serviceParams = true;
        }
        if (this.queryParamPattern.matcher(serviceURL).matches()) {
            throw new QueryExecException("SERVICE URL overrides the 'query' SPARQL protocol parameter");
        }
        this.serviceURL = serviceURL;
    }

    private String getQueryString() {
        if (this.queryString == null) {
            this.queryString = super.httpString();
        }
        return this.queryString;
    }

    public HttpURLConnection getConnection() {
        return this.httpConnection;
    }

    public void setAccept(String contentType) {
        this.contentTypeResult = contentType;
    }

    public String getContentType() {
        return this.contentTypeResult;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setAllowGZip(boolean allow) {
        this.allowGZip = allow;
    }

    public void setAllowDeflate(boolean allow) {
        this.allowDeflate = allow;
    }

    public void setBasicAuthentication(String user, char[] password) {
        this.user = user;
        this.password = password;
    }

    public boolean usesPOST() {
        if (this.forcePOST) {
            return true;
        }
        String s = this.getQueryString();
        return this.serviceURL.length() + s.length() >= urlLimit;
    }

    public void setForcePOST() {
        this.forcePOST = true;
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public InputStream exec() throws QueryExceptionHTTP {
        try {
            if (this.usesPOST()) {
                return this.execPost();
            }
            return this.execGet();
        }
        catch (QueryExceptionHTTP httpEx) {
            log.trace("Exception in exec", (Throwable)((Object)httpEx));
            throw httpEx;
        }
        catch (JenaException jEx) {
            log.trace("JenaException in exec", (Throwable)jEx);
            throw jEx;
        }
    }

    private InputStream execGet() throws QueryExceptionHTTP {
        URL target = null;
        String qs = this.getQueryString();
        ARQ.getHttpRequestLogger().trace(qs);
        try {
            target = this.count() == 0 ? new URL(this.serviceURL) : new URL(this.serviceURL + (this.serviceParams ? "&" : "?") + qs);
        }
        catch (MalformedURLException malEx) {
            throw new QueryExceptionHTTP(0, "Malformed URL: " + malEx);
        }
        log.trace("GET " + target.toExternalForm());
        try {
            this.httpConnection = (HttpURLConnection)target.openConnection();
            this.httpConnection.setInstanceFollowRedirects(true);
            this.httpConnection.setRequestProperty("Accept", this.contentTypeResult);
            int x = this.httpConnection.getReadTimeout();
            this.basicAuthentication(this.httpConnection);
            this.applyTimeouts(this.httpConnection);
            this.applyEncodings(this.httpConnection);
            this.httpConnection.setDoInput(true);
            this.httpConnection.connect();
            try {
                return this.execCommon();
            }
            catch (QueryExceptionHTTP qEx) {
                if (qEx.getResponseCode() == 414) {
                    return this.execPost();
                }
                throw qEx;
            }
        }
        catch (ConnectException connEx) {
            throw new QueryExceptionHTTP(-404, "Failed to connect to remote server");
        }
        catch (IOException ioEx) {
            throw new QueryExceptionHTTP(ioEx);
        }
    }

    private InputStream execPost() throws QueryExceptionHTTP {
        URL target = null;
        try {
            target = new URL(this.serviceURL);
        }
        catch (MalformedURLException malEx) {
            throw new QueryExceptionHTTP(0, "Malformed URL: " + malEx);
        }
        log.trace("POST " + target.toExternalForm());
        ARQ.getHttpRequestLogger().trace(target.toExternalForm());
        try {
            this.httpConnection = (HttpURLConnection)target.openConnection();
            this.httpConnection.setRequestMethod("POST");
            this.httpConnection.setRequestProperty("Accept", this.contentTypeResult);
            this.httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.basicAuthentication(this.httpConnection);
            this.applyTimeouts(this.httpConnection);
            this.applyEncodings(this.httpConnection);
            this.httpConnection.setDoOutput(true);
            boolean first = true;
            OutputStream out = this.httpConnection.getOutputStream();
            ListIterator<Params.Pair> iter = this.pairs().listIterator();
            while (iter.hasNext()) {
                if (!first) {
                    out.write(38);
                }
                first = false;
                Params.Pair p = (Params.Pair)iter.next();
                out.write(p.getName().getBytes());
                out.write(61);
                String x = p.getValue();
                x = Convert.encWWWForm(x);
                out.write(x.getBytes());
                ARQ.getHttpRequestLogger().trace("Param: " + x);
            }
            out.flush();
            this.httpConnection.connect();
            return this.execCommon();
        }
        catch (ConnectException connEx) {
            throw new QueryExceptionHTTP(-1, "Failed to connect to remote server");
        }
        catch (SocketTimeoutException timeoutEx) {
            throw new QueryExceptionHTTP(-1, "Failed to connect to remove server within specified timeout");
        }
        catch (IOException ioEx) {
            throw new QueryExceptionHTTP(ioEx);
        }
    }

    private void basicAuthentication(HttpURLConnection httpConnection2) {
        if (this.user != null || this.password != null) {
            try {
                int i;
                if (this.user == null || this.password == null) {
                    log.warn("Only one of user/password is set");
                }
                StringBuffer x = new StringBuffer();
                byte[] b = x.append(this.user).append(":").append(this.password).toString().getBytes("UTF-8");
                String y = Base64.encodeBase64String((byte[])b);
                this.httpConnection.setRequestProperty("Authorization", "Basic " + y);
                for (i = 0; i < x.length(); ++i) {
                    x.setCharAt(i, '*');
                }
                for (i = 0; i < b.length; ++i) {
                    b[i] = 0;
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new ARQInternalErrorException("UTF-8 is broken on this platform", ex);
            }
        }
    }

    private void applyTimeouts(HttpURLConnection conn) {
        if (this.connectTimeout > 0) {
            conn.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            conn.setReadTimeout(this.readTimeout);
        }
    }

    private void applyEncodings(HttpURLConnection conn) {
        ArrayList<String> encodings = new ArrayList<String>();
        if (this.allowGZip) {
            encodings.add("gzip");
        }
        if (this.allowDeflate) {
            encodings.add("deflate");
        }
        if (encodings.size() > 0) {
            conn.setRequestProperty("Accept-Encoding", StrUtils.strjoin(", ", encodings));
        }
    }

    private InputStream execCommon() throws QueryExceptionHTTP {
        try {
            String contentEnc;
            this.responseCode = this.httpConnection.getResponseCode();
            this.responseMessage = Convert.decWWWForm(this.httpConnection.getResponseMessage());
            if (300 <= this.responseCode && this.responseCode < 400) {
                throw new QueryExceptionHTTP(this.responseCode, this.responseMessage);
            }
            if (this.responseCode >= 400) {
                InputStream x = this.httpConnection.getErrorStream();
                if (x != null) {
                    String str2 = FileUtils.readWholeFileAsUTF8((InputStream)x);
                    throw new QueryExceptionHTTP(this.responseCode, this.responseMessage + "\n" + str2);
                }
                throw new QueryExceptionHTTP(this.responseCode, this.responseMessage);
            }
            InputStream in = this.httpConnection.getInputStream();
            this.contentTypeResult = this.httpConnection.getContentType();
            if (this.contentTypeResult.contains(";")) {
                this.contentTypeResult = this.contentTypeResult.substring(0, this.contentTypeResult.indexOf(59));
            }
            if ((contentEnc = this.httpConnection.getContentEncoding()) != null) {
                if (contentEnc.equalsIgnoreCase("gzip")) {
                    if (!(in instanceof GZIPInputStream)) {
                        in = new GZIPInputStream(in);
                    }
                } else if (contentEnc.equalsIgnoreCase("deflate") && !(in instanceof DeflaterInputStream)) {
                    in = new DeflaterInputStream(in);
                }
            }
            return in;
        }
        catch (IOException ioEx) {
            throw new QueryExceptionHTTP(ioEx);
        }
        catch (QueryExceptionHTTP httpEx) {
            throw httpEx;
        }
        catch (JenaException rdfEx) {
            throw new QueryExceptionHTTP(rdfEx);
        }
    }

    public String toString() {
        String s = this.httpString();
        if (s != null && s.length() > 0) {
            return this.serviceURL + "?" + s;
        }
        return this.serviceURL;
    }
}

